/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.taiyi.typulse.tyusbsdk.pulse.util.AppManager;
import com.taiyi.typulse.tyusbsdk.pulse.util.DialogTipUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.statusbar.StatusBarUtil;
import java.util.ArrayList;

public abstract class BaseActivity
extends AppCompatActivity {
    protected boolean isStopped;
    protected String TAG = ((Object)((Object)this)).getClass().getSimpleName();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        int orientation;
        super.onCreate(savedInstanceState);
        if (this.getIntent() != null && this.getIntent().hasExtra("orientation") && (orientation = this.getIntent().getIntExtra("orientation", -1)) != -1) {
            this.setRequestedOrientation(orientation);
        }
        if (this.initLayoutResId() != 0) {
            this.setContentView(this.initLayoutResId());
        } else {
            this.setContentView(this.initContentView());
        }
        this.getWindow().getDecorView().setSystemUiVisibility(4);
        AppManager.getAppManager().addActivity((Activity)this);
        this.init();
    }

    protected void onStart() {
        super.onStart();
        this.isStopped = false;
    }

    protected void onStop() {
        super.onStop();
        this.isStopped = true;
    }

    protected void onDestroy() {
        super.onDestroy();
        AppManager.getAppManager().removeActivity((Activity)this);
    }

    protected void setOrientation(int orientation) {
        this.setRequestedOrientation(orientation);
    }

    protected void otherSet() {
    }

    protected abstract int initLayoutResId();

    protected View initContentView() {
        return null;
    }

    protected abstract void init();

    protected void removeViewData() {
    }

    public Resources getResources() {
        Resources resources = super.getResources();
        Configuration newConfig = resources.getConfiguration();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (resources != null && newConfig.fontScale != 1.0f) {
            newConfig.fontScale = 1.0f;
            if (Build.VERSION.SDK_INT >= 17) {
                Context configurationContext = this.createConfigurationContext(newConfig);
                resources = configurationContext.getResources();
                displayMetrics.scaledDensity = displayMetrics.density * newConfig.fontScale;
            } else {
                resources.updateConfiguration(newConfig, displayMetrics);
            }
        }
        return resources;
    }

    protected void onPermissionGet(int requestCode) {
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            this.onPermissionGet(requestCode);
        }
    }

    protected void popupPermissionTip(final String permission2, int tips, final int requestCode) {
        DialogTipUtil.show((Context)this, false, false, this.getString(tips), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String[] strings = new String[]{permission2};
                ActivityCompat.requestPermissions((Activity)BaseActivity.this, (String[])strings, (int)requestCode);
            }
        }, null);
    }

    protected void popupPermissionTip(final ArrayList<String> permission2, int tips, final int requestCode) {
        DialogTipUtil.show((Context)this, false, false, this.getString(tips), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String[] strings = permission2.toArray(new String[permission2.size()]);
                LogUtil.w(BaseActivity.this.TAG, "permission:" + permission2);
                ActivityCompat.requestPermissions((Activity)BaseActivity.this, (String[])strings, (int)requestCode);
            }
        }, null);
    }

    protected void popupPermissionTip(String permission2, int tips) {
        this.popupPermissionTip(permission2, tips, 1);
    }

    protected boolean changeStatus() {
        return true;
    }

    protected boolean fitSystemWindows() {
        return true;
    }

    protected boolean translucentStatus() {
        return false;
    }

    protected int setStatusBarColor() {
        return ContextCompat.getColor((Context)this, (int)17170443);
    }

    protected void setStatus(boolean fitSystemWindows, boolean translucentStatus, int color2) {
        StatusBarUtil.setRootViewFitsSystemWindows((Activity)this, fitSystemWindows);
        if (translucentStatus) {
            StatusBarUtil.setTranslucentStatus((Activity)this);
        } else {
            StatusBarUtil.setStatusBarColor((Activity)this, color2);
        }
        if (!StatusBarUtil.setStatusBarDarkTheme((Activity)this, true)) {
            StatusBarUtil.setStatusBarColor((Activity)this, 0x55000000);
        }
    }
}

