/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.ui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.pulse.ui.BaseActivity;

public class HelpActivity
extends BaseActivity {
    ProgressBar mProgress;
    TextView mTvTitle;
    WebView mWebView;
    private ImageView mIvBack;

    @Override
    protected int initLayoutResId() {
        return R.layout.activity_help;
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    protected void init() {
        this.mProgress = (ProgressBar)this.findViewById(R.id.progress);
        this.mTvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.mWebView = (WebView)this.findViewById(R.id.web);
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_back);
        this.setupWebView();
        String url = "https://hybrid.taiyi-tech.com/help.html#/taiyimai?title=" + this.mTvTitle.getText().toString();
        this.mWebView.loadUrl(url);
        this.mIvBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HelpActivity.this.onBackPressed();
            }
        });
    }

    private void setupWebView() {
        this.setWebViewSettings();
        this.setWebClient();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setWebViewSettings() {
        WebSettings settings = this.mWebView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setBuiltInZoomControls(true);
        settings.setDisplayZoomControls(true);
        settings.setSupportZoom(true);
        this.fixVideoBug(settings);
        this.mWebView.getSettings().setBuiltInZoomControls(true);
        this.mWebView.getSettings().setDisplayZoomControls(false);
    }

    @TargetApi(value=21)
    private void fixVideoBug(WebSettings settings) {
        if (Build.VERSION.SDK_INT > 19) {
            settings.setMixedContentMode(0);
            CookieManager.getInstance().setAcceptThirdPartyCookies(this.mWebView, true);
        }
    }

    private void setWebClient() {
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                HelpActivity.this.mTvTitle.setText((CharSequence)title);
            }

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (HelpActivity.this.mProgress != null) {
                    HelpActivity.this.mProgress.setProgress(newProgress);
                }
            }
        });
        this.mWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                if (HelpActivity.this.mProgress != null) {
                    HelpActivity.this.mProgress.setVisibility(0);
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (HelpActivity.this.mProgress != null) {
                    HelpActivity.this.mProgress.setVisibility(8);
                }
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                handler.proceed();
            }
        });
    }

    @Override
    protected void removeViewData() {
        this.mWebView.removeAllViews();
        this.mWebView.destroy();
    }

    public void onBackPressed() {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        } else {
            super.onBackPressed();
        }
    }
}

