/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.animal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.animation.Interpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class FishLoadingRenderer
extends LoadingRenderer {
    private Interpolator FISH_INTERPOLATOR = new FishInterpolator();
    private static final float DEFAULT_PATH_FULL_LINE_SIZE = 7.0f;
    private static final float DEFAULT_PATH_DOTTED_LINE_SIZE = 3.5f;
    private static final float DEFAULT_RIVER_HEIGHT = 59.5f;
    private static final float DEFAULT_RIVER_WIDTH = 38.5f;
    private static final float DEFAULT_FISH_EYE_SIZE = 3.5f;
    private static final float DEFAULT_FISH_WIDTH = 21.0f;
    private static final float DEFAULT_FISH_HEIGHT = 31.5f;
    private static final float DEFAULT_WIDTH = 200.0f;
    private static final float DEFAULT_HEIGHT = 150.0f;
    private static final float DEFAULT_RIVER_BANK_WIDTH = 7.0f;
    private static final long ANIMATION_DURATION = 800L;
    private static final float DOTTED_LINE_WIDTH_COUNT = 48.0f;
    private static final float DOTTED_LINE_WIDTH_RATE = 0.020833334f;
    private final float[] FISH_MOVE_POINTS = new float[]{0.0625f, 0.125f, 0.3125f, 0.375f, 0.5625f, 0.625f, 0.8125f, 0.875f};
    private final float FISH_MOVE_POINTS_RATE = 1.0f / (float)this.FISH_MOVE_POINTS.length;
    private static final int DEFAULT_COLOR = Color.parseColor((String)"#fffefed6");
    private final Paint mPaint = new Paint();
    private final RectF mTempBounds = new RectF();
    private final float[] mFishHeadPos = new float[2];
    private Path mRiverPath;
    private PathMeasure mRiverMeasure;
    private float mFishRotateDegrees;
    private float mRiverBankWidth;
    private float mRiverWidth;
    private float mRiverHeight;
    private float mFishWidth;
    private float mFishHeight;
    private float mFishEyeSize;
    private float mPathFullLineSize;
    private float mPathDottedLineSize;
    private int mColor;

    private FishLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
    }

    private void init(Context context) {
        this.mWidth = DensityUtil.dip2px(context, 200.0f);
        this.mHeight = DensityUtil.dip2px(context, 150.0f);
        this.mRiverBankWidth = DensityUtil.dip2px(context, 7.0f);
        this.mPathFullLineSize = DensityUtil.dip2px(context, 7.0f);
        this.mPathDottedLineSize = DensityUtil.dip2px(context, 3.5f);
        this.mFishWidth = DensityUtil.dip2px(context, 21.0f);
        this.mFishHeight = DensityUtil.dip2px(context, 31.5f);
        this.mFishEyeSize = DensityUtil.dip2px(context, 3.5f);
        this.mRiverWidth = DensityUtil.dip2px(context, 38.5f);
        this.mRiverHeight = DensityUtil.dip2px(context, 59.5f);
        this.mColor = DEFAULT_COLOR;
        this.mDuration = 800L;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mRiverBankWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.MITER);
        this.mPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{this.mPathFullLineSize, this.mPathDottedLineSize}, this.mPathDottedLineSize));
    }

    @Override
    protected void draw(Canvas canvas, Rect bounds) {
        int saveCount = canvas.save();
        RectF arcBounds = this.mTempBounds;
        arcBounds.set(bounds);
        this.mPaint.setColor(this.mColor);
        RectF fishRectF = new RectF(this.mFishHeadPos[0] - this.mFishWidth / 2.0f - this.mPathDottedLineSize * 1.2f, this.mFishHeadPos[1] - this.mFishHeight / 2.0f, this.mFishHeadPos[0] + this.mFishWidth / 2.0f + this.mPathDottedLineSize * 1.2f, this.mFishHeadPos[1] + this.mFishHeight / 2.0f);
        Matrix matrix = new Matrix();
        matrix.postRotate(this.mFishRotateDegrees, fishRectF.centerX(), fishRectF.centerY());
        matrix.mapRect(fishRectF);
        int riverSaveCount = canvas.save();
        this.mPaint.setStyle(Paint.Style.STROKE);
        canvas.clipRect(fishRectF, Region.Op.DIFFERENCE);
        canvas.drawPath(this.createRiverPath(arcBounds), this.mPaint);
        canvas.restoreToCount(riverSaveCount);
        int fishSaveCount = canvas.save();
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.rotate(this.mFishRotateDegrees, this.mFishHeadPos[0], this.mFishHeadPos[1]);
        canvas.clipPath(this.createFishEyePath(this.mFishHeadPos[0], this.mFishHeadPos[1] - this.mFishHeight * 0.06f), Region.Op.DIFFERENCE);
        canvas.drawPath(this.createFishPath(this.mFishHeadPos[0], this.mFishHeadPos[1]), this.mPaint);
        canvas.restoreToCount(fishSaveCount);
        canvas.restoreToCount(saveCount);
    }

    private float calculateRotateDegrees(float fishProgress) {
        if (fishProgress < this.FISH_MOVE_POINTS_RATE * 2.0f) {
            return 90.0f;
        }
        if (fishProgress < this.FISH_MOVE_POINTS_RATE * 4.0f) {
            return 180.0f;
        }
        if (fishProgress < this.FISH_MOVE_POINTS_RATE * 6.0f) {
            return 270.0f;
        }
        return 0.0f;
    }

    @Override
    protected void computeRender(float renderProgress) {
        if (this.mRiverPath == null) {
            return;
        }
        if (this.mRiverMeasure == null) {
            this.mRiverMeasure = new PathMeasure(this.mRiverPath, false);
        }
        float fishProgress = this.FISH_INTERPOLATOR.getInterpolation(renderProgress);
        this.mRiverMeasure.getPosTan(this.mRiverMeasure.getLength() * fishProgress, this.mFishHeadPos, null);
        this.mFishRotateDegrees = this.calculateRotateDegrees(fishProgress);
    }

    @Override
    protected void setAlpha(int alpha) {
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
    }

    @Override
    protected void reset() {
    }

    private Path createFishEyePath(float fishEyeCenterX, float fishEyeCenterY) {
        Path path = new Path();
        path.addCircle(fishEyeCenterX, fishEyeCenterY, this.mFishEyeSize, Path.Direction.CW);
        return path;
    }

    private Path createFishPath(float fishCenterX, float fishCenterY) {
        Path path = new Path();
        float fishHeadX = fishCenterX;
        float fishHeadY = fishCenterY - this.mFishHeight / 2.0f;
        path.moveTo(fishHeadX, fishHeadY);
        path.quadTo(fishHeadX - this.mFishWidth * 0.333f, fishHeadY + this.mFishHeight * 0.222f, fishHeadX - this.mFishWidth * 0.333f, fishHeadY + this.mFishHeight * 0.444f);
        path.lineTo(fishHeadX - this.mFishWidth * 0.333f, fishHeadY + this.mFishHeight * 0.666f);
        path.lineTo(fishHeadX - this.mFishWidth * 0.5f, fishHeadY + this.mFishHeight * 0.8f);
        path.lineTo(fishHeadX - this.mFishWidth * 0.5f, fishHeadY + this.mFishHeight);
        path.lineTo(fishHeadX, fishHeadY + this.mFishHeight * 0.9f);
        path.lineTo(fishHeadX + this.mFishWidth * 0.5f, fishHeadY + this.mFishHeight);
        path.lineTo(fishHeadX + this.mFishWidth * 0.5f, fishHeadY + this.mFishHeight * 0.8f);
        path.lineTo(fishHeadX + this.mFishWidth * 0.333f, fishHeadY + this.mFishHeight * 0.666f);
        path.lineTo(fishHeadX + this.mFishWidth * 0.333f, fishHeadY + this.mFishHeight * 0.444f);
        path.quadTo(fishHeadX + this.mFishWidth * 0.333f, fishHeadY + this.mFishHeight * 0.222f, fishHeadX, fishHeadY);
        path.close();
        return path;
    }

    private Path createRiverPath(RectF arcBounds) {
        if (this.mRiverPath != null) {
            return this.mRiverPath;
        }
        this.mRiverPath = new Path();
        RectF rectF = new RectF(arcBounds.centerX() - this.mRiverWidth / 2.0f, arcBounds.centerY() - this.mRiverHeight / 2.0f, arcBounds.centerX() + this.mRiverWidth / 2.0f, arcBounds.centerY() + this.mRiverHeight / 2.0f);
        rectF.inset(this.mRiverBankWidth / 2.0f, this.mRiverBankWidth / 2.0f);
        this.mRiverPath.addRect(rectF, Path.Direction.CW);
        return this.mRiverPath;
    }

    private class FishInterpolator
    implements Interpolator {
        private FishInterpolator() {
        }

        public float getInterpolation(float input) {
            int index = (int)(input / FishLoadingRenderer.this.FISH_MOVE_POINTS_RATE);
            if (index >= FishLoadingRenderer.this.FISH_MOVE_POINTS.length) {
                index = FishLoadingRenderer.this.FISH_MOVE_POINTS.length - 1;
            }
            return FishLoadingRenderer.this.FISH_MOVE_POINTS[index];
        }
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public FishLoadingRenderer build() {
            FishLoadingRenderer loadingRenderer = new FishLoadingRenderer(this.mContext);
            return loadingRenderer;
        }
    }
}

