/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.animal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.animation.Interpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class GhostsEyeLoadingRenderer
extends LoadingRenderer {
    private Interpolator EYE_BALL_INTERPOLATOR = new EyeBallInterpolator();
    private Interpolator EYE_CIRCLE_INTERPOLATOR = new EyeCircleInterpolator();
    private static final float DEFAULT_WIDTH = 200.0f;
    private static final float DEFAULT_HEIGHT = 176.0f;
    private static final float DEFAULT_EYE_EDGE_WIDTH = 5.0f;
    private static final float DEFAULT_EYE_BALL_HEIGHT = 9.0f;
    private static final float DEFAULT_EYE_BALL_WIDTH = 11.0f;
    private static final float DEFAULT_EYE_CIRCLE_INTERVAL = 8.0f;
    private static final float DEFAULT_EYE_BALL_OFFSET_Y = 2.0f;
    private static final float DEFAULT_ABOVE_RADIAN_EYE_CIRCLE_OFFSET = 6.0f;
    private static final float DEFAULT_EYE_CIRCLE_RADIUS = 21.0f;
    private static final float DEFAULT_MAX_EYE_JUMP_DISTANCE = 11.0f;
    private static final float LEFT_EYE_CIRCLE$BALL_START_JUMP_UP_OFFSET = 0.0f;
    private static final float RIGHT_EYE_CIRCLE$BALL_START_JUMP_UP_OFFSET = 0.067f;
    private static final float LEFT_EYE_BALL_END_JUMP_OFFSET = 0.4f;
    private static final float LEFT_EYE_CIRCLE_END_JUMP_OFFSET = 0.533f;
    private static final float RIGHT_EYE_BALL_END_JUMP_OFFSET = 0.467f;
    private static final float RIGHT_EYE_CIRCLE_END_JUMP_OFFSET = 0.6f;
    private static final int DEGREE_180 = 180;
    private static final long ANIMATION_DURATION = 2333L;
    private static final int DEFAULT_COLOR = Color.parseColor((String)"#ff484852");
    private final Paint mPaint = new Paint();
    private final RectF mTempBounds = new RectF();
    private float mEyeInterval;
    private float mEyeCircleRadius;
    private float mMaxEyeJumptDistance;
    private float mAboveRadianEyeOffsetX;
    private float mEyeBallOffsetY;
    private float mEyeEdgeWidth;
    private float mEyeBallWidth;
    private float mEyeBallHeight;
    private float mLeftEyeCircleOffsetY;
    private float mRightEyeCircleOffsetY;
    private float mLeftEyeBallOffsetY;
    private float mRightEyeBallOffsetY;
    private int mColor;

    private GhostsEyeLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
    }

    private void init(Context context) {
        this.mWidth = DensityUtil.dip2px(context, 200.0f);
        this.mHeight = DensityUtil.dip2px(context, 176.0f);
        this.mEyeEdgeWidth = DensityUtil.dip2px(context, 5.0f);
        this.mEyeInterval = DensityUtil.dip2px(context, 8.0f);
        this.mEyeBallOffsetY = DensityUtil.dip2px(context, 2.0f);
        this.mEyeCircleRadius = DensityUtil.dip2px(context, 21.0f);
        this.mMaxEyeJumptDistance = DensityUtil.dip2px(context, 11.0f);
        this.mAboveRadianEyeOffsetX = DensityUtil.dip2px(context, 6.0f);
        this.mEyeBallWidth = DensityUtil.dip2px(context, 11.0f);
        this.mEyeBallHeight = DensityUtil.dip2px(context, 9.0f);
        this.mColor = DEFAULT_COLOR;
        this.mDuration = 2333L;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mEyeEdgeWidth);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    @Override
    protected void draw(Canvas canvas, Rect bounds) {
        int saveCount = canvas.save();
        RectF arcBounds = this.mTempBounds;
        arcBounds.set(bounds);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        canvas.drawPath(this.createLeftEyeCircle(arcBounds, this.mLeftEyeCircleOffsetY), this.mPaint);
        canvas.drawPath(this.createRightEyeCircle(arcBounds, this.mRightEyeCircleOffsetY), this.mPaint);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawOval(this.createLeftEyeBall(arcBounds, this.mLeftEyeBallOffsetY), this.mPaint);
        canvas.drawOval(this.createRightEyeBall(arcBounds, this.mRightEyeBallOffsetY), this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        float eyeCircle$BallJumpUpProgress;
        if (renderProgress <= 0.4f && renderProgress >= 0.0f) {
            eyeCircle$BallJumpUpProgress = (renderProgress - 0.0f) / 0.4f;
            this.mLeftEyeBallOffsetY = -this.mMaxEyeJumptDistance * this.EYE_BALL_INTERPOLATOR.getInterpolation(eyeCircle$BallJumpUpProgress);
        }
        if (renderProgress <= 0.533f && renderProgress >= 0.0f) {
            eyeCircle$BallJumpUpProgress = (renderProgress - 0.0f) / 0.533f;
            this.mLeftEyeCircleOffsetY = -this.mMaxEyeJumptDistance * this.EYE_CIRCLE_INTERPOLATOR.getInterpolation(eyeCircle$BallJumpUpProgress);
        }
        if (renderProgress <= 0.467f && renderProgress >= 0.067f) {
            eyeCircle$BallJumpUpProgress = (renderProgress - 0.067f) / 0.4f;
            this.mRightEyeBallOffsetY = -this.mMaxEyeJumptDistance * this.EYE_BALL_INTERPOLATOR.getInterpolation(eyeCircle$BallJumpUpProgress);
        }
        if (renderProgress <= 0.6f && renderProgress >= 0.067f) {
            eyeCircle$BallJumpUpProgress = (renderProgress - 0.067f) / 0.533f;
            this.mRightEyeCircleOffsetY = -this.mMaxEyeJumptDistance * this.EYE_CIRCLE_INTERPOLATOR.getInterpolation(eyeCircle$BallJumpUpProgress);
        }
    }

    @Override
    protected void setAlpha(int alpha) {
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
    }

    @Override
    protected void reset() {
        this.mLeftEyeBallOffsetY = 0.0f;
        this.mRightEyeBallOffsetY = 0.0f;
        this.mLeftEyeCircleOffsetY = 0.0f;
        this.mRightEyeCircleOffsetY = 0.0f;
    }

    private RectF createLeftEyeBall(RectF arcBounds, float offsetY) {
        float leftEyeCenterX = arcBounds.centerX() - this.mEyeInterval / 2.0f - this.mEyeCircleRadius;
        float leftEyeCenterY = arcBounds.centerY() - this.mEyeBallOffsetY + offsetY;
        RectF rectF = new RectF(leftEyeCenterX - this.mEyeBallWidth / 2.0f, leftEyeCenterY - this.mEyeBallHeight / 2.0f, leftEyeCenterX + this.mEyeBallWidth / 2.0f, leftEyeCenterY + this.mEyeBallHeight / 2.0f);
        return rectF;
    }

    private RectF createRightEyeBall(RectF arcBounds, float offsetY) {
        float rightEyeCenterX = arcBounds.centerX() + this.mEyeInterval / 2.0f + this.mEyeCircleRadius;
        float rightEyeCenterY = arcBounds.centerY() - this.mEyeBallOffsetY + offsetY;
        RectF rectF = new RectF(rightEyeCenterX - this.mEyeBallWidth / 2.0f, rightEyeCenterY - this.mEyeBallHeight / 2.0f, rightEyeCenterX + this.mEyeBallWidth / 2.0f, rightEyeCenterY + this.mEyeBallHeight / 2.0f);
        return rectF;
    }

    private Path createLeftEyeCircle(RectF arcBounds, float offsetY) {
        Path path = new Path();
        float leftEyeCenterX = arcBounds.centerX() - this.mEyeInterval / 2.0f - this.mEyeCircleRadius;
        float leftEyeCenterY = arcBounds.centerY() + offsetY;
        RectF leftEyeBounds = new RectF(leftEyeCenterX - this.mEyeCircleRadius, leftEyeCenterY - this.mEyeCircleRadius, leftEyeCenterX + this.mEyeCircleRadius, leftEyeCenterY + this.mEyeCircleRadius);
        path.addArc(leftEyeBounds, 0.0f, 195.0f);
        path.quadTo(leftEyeBounds.left + this.mAboveRadianEyeOffsetX, leftEyeBounds.top + this.mEyeCircleRadius * 0.2f, leftEyeBounds.left + this.mAboveRadianEyeOffsetX / 4.0f, leftEyeBounds.top - this.mEyeCircleRadius * 0.15f);
        return path;
    }

    private Path createRightEyeCircle(RectF arcBounds, float offsetY) {
        Path path = new Path();
        float rightEyeCenterX = arcBounds.centerX() + this.mEyeInterval / 2.0f + this.mEyeCircleRadius;
        float rightEyeCenterY = arcBounds.centerY() + offsetY;
        RectF leftEyeBounds = new RectF(rightEyeCenterX - this.mEyeCircleRadius, rightEyeCenterY - this.mEyeCircleRadius, rightEyeCenterX + this.mEyeCircleRadius, rightEyeCenterY + this.mEyeCircleRadius);
        path.addArc(leftEyeBounds, 180.0f, -195.0f);
        path.quadTo(leftEyeBounds.right - this.mAboveRadianEyeOffsetX, leftEyeBounds.top + this.mEyeCircleRadius * 0.2f, leftEyeBounds.right - this.mAboveRadianEyeOffsetX / 4.0f, leftEyeBounds.top - this.mEyeCircleRadius * 0.15f);
        return path;
    }

    private class EyeBallInterpolator
    implements Interpolator {
        private EyeBallInterpolator() {
        }

        public float getInterpolation(float input) {
            if (input < 0.333333f) {
                return input * 3.0f;
            }
            return 1.0f - (input - 0.333333f) * 1.5f;
        }
    }

    private class EyeCircleInterpolator
    implements Interpolator {
        private EyeCircleInterpolator() {
        }

        public float getInterpolation(float input) {
            if (input < 0.25f) {
                return input * 4.0f;
            }
            if (input < 0.5f) {
                return 1.0f - (input - 0.25f) * 4.0f;
            }
            if (input < 0.75f) {
                return (input - 0.5f) * 2.0f;
            }
            return 0.5f - (input - 0.75f) * 2.0f;
        }
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public GhostsEyeLoadingRenderer build() {
            GhostsEyeLoadingRenderer loadingRenderer = new GhostsEyeLoadingRenderer(this.mContext);
            return loadingRenderer;
        }
    }
}

