/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.goods;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.animation.Interpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WaterBottleLoadingRenderer
extends LoadingRenderer {
    private static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final float DEFAULT_WIDTH = 200.0f;
    private static final float DEFAULT_HEIGHT = 150.0f;
    private static final float DEFAULT_STROKE_WIDTH = 1.5f;
    private static final float DEFAULT_BOTTLE_WIDTH = 30.0f;
    private static final float DEFAULT_BOTTLE_HEIGHT = 43.0f;
    private static final float WATER_LOWEST_POINT_TO_BOTTLENECK_DISTANCE = 30.0f;
    private static final int DEFAULT_WAVE_COUNT = 5;
    private static final int DEFAULT_WATER_DROP_COUNT = 25;
    private static final int MAX_WATER_DROP_RADIUS = 5;
    private static final int MIN_WATER_DROP_RADIUS = 1;
    private static final int DEFAULT_BOTTLE_COLOR = Color.parseColor((String)"#FFDAEBEB");
    private static final int DEFAULT_WATER_COLOR = Color.parseColor((String)"#FF29E3F2");
    private static final float DEFAULT_TEXT_SIZE = 7.0f;
    private static final String LOADING_TEXT = "loading";
    private static final long ANIMATION_DURATION = 11111L;
    private final Random mRandom = new Random();
    private final Paint mPaint = new Paint();
    private final RectF mCurrentBounds = new RectF();
    private final RectF mBottleBounds = new RectF();
    private final RectF mWaterBounds = new RectF();
    private final Rect mLoadingBounds = new Rect();
    private final List<WaterDropHolder> mWaterDropHolders = new ArrayList<WaterDropHolder>();
    private float mTextSize;
    private float mProgress;
    private float mBottleWidth;
    private float mBottleHeight;
    private float mStrokeWidth;
    private float mWaterLowestPointToBottleneckDistance;
    private int mBottleColor;
    private int mWaterColor;
    private int mWaveCount;

    private WaterBottleLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
    }

    private void init(Context context) {
        this.mTextSize = DensityUtil.dip2px(context, 7.0f);
        this.mWidth = DensityUtil.dip2px(context, 200.0f);
        this.mHeight = DensityUtil.dip2px(context, 150.0f);
        this.mStrokeWidth = DensityUtil.dip2px(context, 1.5f);
        this.mBottleWidth = DensityUtil.dip2px(context, 30.0f);
        this.mBottleHeight = DensityUtil.dip2px(context, 43.0f);
        this.mWaterLowestPointToBottleneckDistance = DensityUtil.dip2px(context, 30.0f);
        this.mBottleColor = DEFAULT_BOTTLE_COLOR;
        this.mWaterColor = DEFAULT_WATER_COLOR;
        this.mWaveCount = 5;
        this.mDuration = 11111L;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
    }

    @Override
    protected void draw(Canvas canvas, Rect bounds) {
        int saveCount = canvas.save();
        RectF arcBounds = this.mCurrentBounds;
        arcBounds.set(bounds);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mBottleColor);
        canvas.drawPath(this.createBottlePath(this.mBottleBounds), this.mPaint);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaint.setColor(this.mWaterColor);
        canvas.drawPath(this.createWaterPath(this.mWaterBounds, this.mProgress), this.mPaint);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mWaterColor);
        for (WaterDropHolder waterDropHolder : this.mWaterDropHolders) {
            if (!waterDropHolder.mNeedDraw) continue;
            canvas.drawCircle(waterDropHolder.mInitX, waterDropHolder.mCurrentY, waterDropHolder.mRadius, this.mPaint);
        }
        this.mPaint.setColor(this.mBottleColor);
        canvas.drawText(LOADING_TEXT, this.mBottleBounds.centerX() - (float)this.mLoadingBounds.width() / 2.0f, this.mBottleBounds.bottom + this.mBottleBounds.height() * 0.2f, this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        if (this.mCurrentBounds.width() <= 0.0f) {
            return;
        }
        RectF arcBounds = this.mCurrentBounds;
        this.mBottleBounds.set(arcBounds.centerX() - this.mBottleWidth / 2.0f, arcBounds.centerY() - this.mBottleHeight / 2.0f, arcBounds.centerX() + this.mBottleWidth / 2.0f, arcBounds.centerY() + this.mBottleHeight / 2.0f);
        this.mWaterBounds.set(this.mBottleBounds.left + this.mStrokeWidth * 1.5f, this.mBottleBounds.top + this.mWaterLowestPointToBottleneckDistance, this.mBottleBounds.right - this.mStrokeWidth * 1.5f, this.mBottleBounds.bottom - this.mStrokeWidth * 1.5f);
        float totalWaveProgress = renderProgress * (float)this.mWaveCount;
        float currentWaveProgress = totalWaveProgress - (float)((int)totalWaveProgress);
        this.mProgress = currentWaveProgress > 0.5f ? 1.0f - MATERIAL_INTERPOLATOR.getInterpolation((currentWaveProgress - 0.5f) * 2.0f) : MATERIAL_INTERPOLATOR.getInterpolation(currentWaveProgress * 2.0f);
        if (this.mWaterDropHolders.isEmpty()) {
            this.initWaterDropHolders(this.mBottleBounds, this.mWaterBounds);
        }
        for (WaterDropHolder waterDropHolder : this.mWaterDropHolders) {
            if (waterDropHolder.mDelayDuration < renderProgress && waterDropHolder.mDelayDuration + waterDropHolder.mDuration > renderProgress) {
                float riseProgress = (renderProgress - waterDropHolder.mDelayDuration) / waterDropHolder.mDuration;
                riseProgress = riseProgress < 0.5f ? riseProgress * 2.0f : 1.0f - (riseProgress - 0.5f) * 2.0f;
                waterDropHolder.mCurrentY = waterDropHolder.mInitY - MATERIAL_INTERPOLATOR.getInterpolation(riseProgress) * waterDropHolder.mRiseHeight;
                waterDropHolder.mNeedDraw = true;
                continue;
            }
            waterDropHolder.mNeedDraw = false;
        }
        this.mPaint.setTextSize(this.mTextSize);
        this.mPaint.getTextBounds(LOADING_TEXT, 0, LOADING_TEXT.length(), this.mLoadingBounds);
    }

    private Path createBottlePath(RectF bottleRect) {
        float bottleneckWidth = bottleRect.width() * 0.3f;
        float bottleneckHeight = bottleRect.height() * 0.415f;
        float bottleneckDecorationWidth = bottleneckWidth * 1.1f;
        float bottleneckDecorationHeight = bottleneckHeight * 0.167f;
        Path path = new Path();
        path.moveTo(bottleRect.centerX() - bottleneckDecorationWidth * 0.5f, bottleRect.top);
        path.quadTo(bottleRect.centerX() - bottleneckDecorationWidth * 0.5f - bottleneckWidth * 0.15f, bottleRect.top + bottleneckDecorationHeight * 0.5f, bottleRect.centerX() - bottleneckWidth * 0.5f, bottleRect.top + bottleneckDecorationHeight);
        path.lineTo(bottleRect.centerX() - bottleneckWidth * 0.5f, bottleRect.top + bottleneckHeight);
        float radius = (bottleRect.width() - this.mStrokeWidth) / 2.0f;
        float centerY = bottleRect.bottom - 0.86f * radius;
        RectF bodyRect = new RectF(bottleRect.left, centerY - radius, bottleRect.right, centerY + radius);
        path.addArc(bodyRect, 255.0f, -135.0f);
        float bottleBottomWidth = bottleRect.width() / 2.0f;
        path.lineTo(bottleRect.centerX() - bottleBottomWidth / 2.0f, bottleRect.bottom);
        path.lineTo(bottleRect.centerX() + bottleBottomWidth / 2.0f, bottleRect.bottom);
        path.addArc(bodyRect, 60.0f, -135.0f);
        path.lineTo(bottleRect.centerX() + bottleneckWidth * 0.5f, bottleRect.top + bottleneckDecorationHeight);
        path.quadTo(bottleRect.centerX() + bottleneckDecorationWidth * 0.5f + bottleneckWidth * 0.15f, bottleRect.top + bottleneckDecorationHeight * 0.5f, bottleRect.centerX() + bottleneckDecorationWidth * 0.5f, bottleRect.top);
        return path;
    }

    private Path createWaterPath(RectF waterRect, float progress) {
        Path path = new Path();
        path.moveTo(waterRect.left, waterRect.top);
        float radius = (waterRect.width() - this.mStrokeWidth) / 2.0f;
        float centerY = waterRect.bottom - 0.86f * radius;
        float bottleBottomWidth = waterRect.width() / 2.0f;
        RectF bodyRect = new RectF(waterRect.left, centerY - radius, waterRect.right, centerY + radius);
        path.addArc(bodyRect, 187.5f, -67.5f);
        path.lineTo(waterRect.centerX() - bottleBottomWidth / 2.0f, waterRect.bottom);
        path.lineTo(waterRect.centerX() + bottleBottomWidth / 2.0f, waterRect.bottom);
        path.addArc(bodyRect, 60.0f, -67.5f);
        float cubicXChangeSize = waterRect.width() * 0.35f * progress;
        float cubicYChangeSize = waterRect.height() * 1.2f * progress;
        path.cubicTo(waterRect.left + waterRect.width() * 0.8f - cubicXChangeSize, waterRect.top - waterRect.height() * 1.2f + cubicYChangeSize, waterRect.left + waterRect.width() * 0.55f - cubicXChangeSize, waterRect.top - cubicYChangeSize, waterRect.left, waterRect.top - this.mStrokeWidth / 2.0f);
        path.lineTo(waterRect.left, waterRect.top);
        return path;
    }

    private void initWaterDropHolders(RectF bottleRect, RectF waterRect) {
        float bottleRadius = bottleRect.width() / 2.0f;
        float lowestWaterPointY = waterRect.top;
        float twoSidesInterval = 0.2f * bottleRect.width();
        float atLeastDelayDuration = 0.1f;
        float unitDuration = 0.1f;
        float delayDurationRange = 0.6f;
        int radiusRandomRange = 4;
        float currentXRandomRange = bottleRect.width() * 0.6f;
        for (int i = 0; i < 25; ++i) {
            WaterDropHolder waterDropHolder = new WaterDropHolder();
            waterDropHolder.mRadius = 1 + this.mRandom.nextInt(radiusRandomRange);
            waterDropHolder.mInitX = bottleRect.left + twoSidesInterval + this.mRandom.nextFloat() * currentXRandomRange;
            waterDropHolder.mInitY = lowestWaterPointY + waterDropHolder.mRadius / 2.0f;
            waterDropHolder.mRiseHeight = this.getMaxRiseHeight(bottleRadius, waterDropHolder.mRadius, waterDropHolder.mInitX - bottleRect.left) * (0.2f + 0.8f * this.mRandom.nextFloat());
            waterDropHolder.mDelayDuration = atLeastDelayDuration + this.mRandom.nextFloat() * delayDurationRange;
            waterDropHolder.mDuration = waterDropHolder.mRiseHeight / bottleRadius * unitDuration;
            this.mWaterDropHolders.add(waterDropHolder);
        }
    }

    private float getMaxRiseHeight(float bottleRadius, float waterDropRadius, float currentX) {
        float coordinateX = currentX - bottleRadius;
        float bottleneckRadius = bottleRadius * 0.3f;
        if (coordinateX - waterDropRadius > -bottleneckRadius && coordinateX + waterDropRadius < bottleneckRadius) {
            return bottleRadius * 2.0f;
        }
        return (float)(Math.sqrt(Math.pow(bottleRadius, 2.0) - Math.pow(coordinateX, 2.0)) - (double)waterDropRadius);
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
    }

    private class WaterDropHolder {
        public float mCurrentY;
        public float mInitX;
        public float mInitY;
        public float mDelayDuration;
        public float mRiseHeight;
        public float mRadius;
        public float mDuration;
        public boolean mNeedDraw;

        private WaterDropHolder() {
        }
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public WaterBottleLoadingRenderer build() {
            WaterBottleLoadingRenderer loadingRenderer = new WaterBottleLoadingRenderer(this.mContext);
            return loadingRenderer;
        }
    }
}

