/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.jump;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.Size;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class CollisionLoadingRenderer
extends LoadingRenderer {
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final int MAX_ALPHA = 255;
    private static final int OVAL_ALPHA = 64;
    private static final int DEFAULT_BALL_COUNT = 7;
    private static final float DEFAULT_OVAL_HEIGHT = 1.5f;
    private static final float DEFAULT_BALL_RADIUS = 7.5f;
    private static final float DEFAULT_WIDTH = 165.0f;
    private static final float DEFAULT_HEIGHT = 60.0f;
    private static final float START_LEFT_DURATION_OFFSET = 0.25f;
    private static final float START_RIGHT_DURATION_OFFSET = 0.5f;
    private static final float END_RIGHT_DURATION_OFFSET = 0.75f;
    private static final float END_LEFT_DURATION_OFFSET = 1.0f;
    private static final int[] DEFAULT_COLORS = new int[]{Color.parseColor((String)"#FF28435D"), Color.parseColor((String)"#FFC32720")};
    private static final float[] DEFAULT_POSITIONS = new float[]{0.0f, 1.0f};
    private final Paint mPaint = new Paint(1);
    private final RectF mOvalRect = new RectF();
    @Size(value=2L)
    private int[] mColors;
    private float[] mPositions;
    private float mOvalVerticalRadius;
    private float mBallRadius;
    private float mBallCenterY;
    private float mBallSideOffsets;
    private float mBallMoveXOffsets;
    private float mBallQuadCoefficient;
    private float mLeftBallMoveXOffsets;
    private float mLeftBallMoveYOffsets;
    private float mRightBallMoveXOffsets;
    private float mRightBallMoveYOffsets;
    private float mLeftOvalShapeRate;
    private float mRightOvalShapeRate;
    private int mBallCount;

    private CollisionLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.adjustParams();
        this.setupPaint();
    }

    private void init(Context context) {
        this.mBallRadius = DensityUtil.dip2px(context, 7.5f);
        this.mWidth = DensityUtil.dip2px(context, 165.0f);
        this.mHeight = DensityUtil.dip2px(context, 60.0f);
        this.mOvalVerticalRadius = DensityUtil.dip2px(context, 1.5f);
        this.mColors = DEFAULT_COLORS;
        this.mPositions = DEFAULT_POSITIONS;
        this.mBallCount = 7;
        this.mBallMoveXOffsets = 1.5f * (2.0f * this.mBallRadius);
        this.mBallQuadCoefficient = 1.0f / this.mBallMoveXOffsets;
    }

    private void adjustParams() {
        this.mBallCenterY = this.mHeight / 2.0f;
        this.mBallSideOffsets = (this.mWidth - this.mBallRadius * 2.0f * (float)(this.mBallCount - 2)) / 2.0f;
    }

    private void setupPaint() {
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setShader((Shader)new LinearGradient(this.mBallSideOffsets, 0.0f, this.mWidth - this.mBallSideOffsets, 0.0f, this.mColors, this.mPositions, Shader.TileMode.CLAMP));
    }

    @Override
    protected void draw(Canvas canvas) {
        int saveCount = canvas.save();
        for (int i = 1; i < this.mBallCount - 1; ++i) {
            this.mPaint.setAlpha(255);
            canvas.drawCircle(this.mBallRadius * (float)(i * 2 - 1) + this.mBallSideOffsets, this.mBallCenterY, this.mBallRadius, this.mPaint);
            this.mOvalRect.set(this.mBallRadius * (float)(i * 2 - 2) + this.mBallSideOffsets, this.mHeight - this.mOvalVerticalRadius * 2.0f, this.mBallRadius * (float)(i * 2) + this.mBallSideOffsets, this.mHeight);
            this.mPaint.setAlpha(64);
            canvas.drawOval(this.mOvalRect, this.mPaint);
        }
        this.mPaint.setAlpha(255);
        canvas.drawCircle(this.mBallSideOffsets - this.mBallRadius - this.mLeftBallMoveXOffsets, this.mBallCenterY - this.mLeftBallMoveYOffsets, this.mBallRadius, this.mPaint);
        this.mOvalRect.set(this.mBallSideOffsets - this.mBallRadius - this.mBallRadius * this.mLeftOvalShapeRate - this.mLeftBallMoveXOffsets, this.mHeight - this.mOvalVerticalRadius - this.mOvalVerticalRadius * this.mLeftOvalShapeRate, this.mBallSideOffsets - this.mBallRadius + this.mBallRadius * this.mLeftOvalShapeRate - this.mLeftBallMoveXOffsets, this.mHeight - this.mOvalVerticalRadius + this.mOvalVerticalRadius * this.mLeftOvalShapeRate);
        this.mPaint.setAlpha(64);
        canvas.drawOval(this.mOvalRect, this.mPaint);
        this.mPaint.setAlpha(255);
        canvas.drawCircle(this.mBallRadius * (float)(this.mBallCount * 2 - 3) + this.mBallSideOffsets + this.mRightBallMoveXOffsets, this.mBallCenterY - this.mRightBallMoveYOffsets, this.mBallRadius, this.mPaint);
        this.mOvalRect.set(this.mBallRadius * (float)(this.mBallCount * 2 - 3) - this.mBallRadius * this.mRightOvalShapeRate + this.mBallSideOffsets + this.mRightBallMoveXOffsets, this.mHeight - this.mOvalVerticalRadius - this.mOvalVerticalRadius * this.mRightOvalShapeRate, this.mBallRadius * (float)(this.mBallCount * 2 - 3) + this.mBallRadius * this.mRightOvalShapeRate + this.mBallSideOffsets + this.mRightBallMoveXOffsets, this.mHeight - this.mOvalVerticalRadius + this.mOvalVerticalRadius * this.mRightOvalShapeRate);
        this.mPaint.setAlpha(64);
        canvas.drawOval(this.mOvalRect, this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        if (renderProgress <= 0.25f) {
            float startLeftOffsetProgress = renderProgress / 0.25f;
            this.computeLeftBallMoveOffsets(DECELERATE_INTERPOLATOR.getInterpolation(startLeftOffsetProgress));
            return;
        }
        if (renderProgress <= 0.5f) {
            float startRightOffsetProgress = (renderProgress - 0.25f) / 0.25f;
            this.computeLeftBallMoveOffsets(ACCELERATE_INTERPOLATOR.getInterpolation(1.0f - startRightOffsetProgress));
            return;
        }
        if (renderProgress <= 0.75f) {
            float endRightOffsetProgress = (renderProgress - 0.5f) / 0.25f;
            this.computeRightBallMoveOffsets(DECELERATE_INTERPOLATOR.getInterpolation(endRightOffsetProgress));
            return;
        }
        if (renderProgress <= 1.0f) {
            float endRightOffsetProgress = (renderProgress - 0.75f) / 0.25f;
            this.computeRightBallMoveOffsets(ACCELERATE_INTERPOLATOR.getInterpolation(1.0f - endRightOffsetProgress));
            return;
        }
    }

    private void computeLeftBallMoveOffsets(float progress) {
        this.mRightBallMoveXOffsets = 0.0f;
        this.mRightBallMoveYOffsets = 0.0f;
        this.mLeftOvalShapeRate = 1.0f - progress;
        this.mLeftBallMoveXOffsets = this.mBallMoveXOffsets * progress;
        this.mLeftBallMoveYOffsets = (float)(Math.pow(this.mLeftBallMoveXOffsets, 2.0) * (double)this.mBallQuadCoefficient);
    }

    private void computeRightBallMoveOffsets(float progress) {
        this.mLeftBallMoveXOffsets = 0.0f;
        this.mLeftBallMoveYOffsets = 0.0f;
        this.mRightOvalShapeRate = 1.0f - progress;
        this.mRightBallMoveXOffsets = this.mBallMoveXOffsets * progress;
        this.mRightBallMoveYOffsets = (float)(Math.pow(this.mRightBallMoveXOffsets, 2.0) * (double)this.mBallQuadCoefficient);
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
    }

    private void apply(Builder builder) {
        this.mWidth = builder.mWidth > 0 ? (float)builder.mWidth : this.mWidth;
        this.mHeight = builder.mHeight > 0 ? (float)builder.mHeight : this.mHeight;
        this.mOvalVerticalRadius = builder.mOvalVerticalRadius > 0.0f ? builder.mOvalVerticalRadius : this.mOvalVerticalRadius;
        this.mBallRadius = builder.mBallRadius > 0.0f ? builder.mBallRadius : this.mBallRadius;
        this.mBallMoveXOffsets = builder.mBallMoveXOffsets > 0.0f ? builder.mBallMoveXOffsets : this.mBallMoveXOffsets;
        this.mBallQuadCoefficient = builder.mBallQuadCoefficient > 0.0f ? builder.mBallQuadCoefficient : this.mBallQuadCoefficient;
        this.mBallCount = builder.mBallCount > 0 ? builder.mBallCount : this.mBallCount;
        this.mDuration = builder.mDuration > 0 ? (long)builder.mDuration : this.mDuration;
        this.mColors = builder.mColors != null ? builder.mColors : this.mColors;
        this.adjustParams();
        this.setupPaint();
    }

    public static class Builder {
        private Context mContext;
        private int mWidth;
        private int mHeight;
        private float mOvalVerticalRadius;
        private int mBallCount;
        private float mBallRadius;
        private float mBallMoveXOffsets;
        private float mBallQuadCoefficient;
        private int mDuration;
        @Size(value=2L)
        private int[] mColors;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder setOvalVerticalRadius(int ovalVerticalRadius) {
            this.mOvalVerticalRadius = ovalVerticalRadius;
            return this;
        }

        public Builder setBallRadius(int ballRadius) {
            this.mBallRadius = ballRadius;
            return this;
        }

        public Builder setBallMoveXOffsets(int ballMoveXOffsets) {
            this.mBallMoveXOffsets = ballMoveXOffsets;
            return this;
        }

        public Builder setBallQuadCoefficient(int ballQuadCoefficient) {
            this.mBallQuadCoefficient = ballQuadCoefficient;
            return this;
        }

        public Builder setBallCount(int ballCount) {
            this.mBallCount = ballCount;
            return this;
        }

        public Builder setColors(@Size(value=2L) int[] colors) {
            this.mColors = colors;
            return this;
        }

        public Builder setDuration(int duration) {
            this.mDuration = duration;
            return this;
        }

        public CollisionLoadingRenderer build() {
            CollisionLoadingRenderer loadingRenderer = new CollisionLoadingRenderer(this.mContext);
            loadingRenderer.apply(this);
            return loadingRenderer;
        }
    }
}

