/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.jump;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class DanceLoadingRenderer
extends LoadingRenderer {
    private static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final long ANIMATION_DURATION = 1888L;
    private static final float DEFAULT_CENTER_RADIUS = 12.5f;
    private static final float DEFAULT_STROKE_WIDTH = 1.5f;
    private static final float DEFAULT_DANCE_BALL_RADIUS = 2.0f;
    private static final int NUM_POINTS = 3;
    private static final int DEGREE_360 = 360;
    private static final int RING_START_ANGLE = -90;
    private static final int DANCE_START_ANGLE = 0;
    private static final int DANCE_INTERVAL_ANGLE = 60;
    private static final int DEFAULT_COLOR = -1;
    private static final float[] POINT_X = new float[3];
    private static final float[] POINT_Y = new float[3];
    private static final int[] DIRECTION = new int[]{1, 1, -1};
    private static final float BALL_FORWARD_START_ENTER_DURATION_OFFSET = 0.0f;
    private static final float BALL_FORWARD_END_ENTER_DURATION_OFFSET = 0.125f;
    private static final float RING_FORWARD_START_ROTATE_DURATION_OFFSET = 0.125f;
    private static final float RING_FORWARD_END_ROTATE_DURATION_OFFSET = 0.375f;
    private static final float CENTER_CIRCLE_FORWARD_START_SCALE_DURATION_OFFSET = 0.225f;
    private static final float CENTER_CIRCLE_FORWARD_END_SCALE_DURATION_OFFSET = 0.475f;
    private static final float BALL_FORWARD_START_EXIT_DURATION_OFFSET = 0.375f;
    private static final float BALL_FORWARD_END_EXIT_DURATION_OFFSET = 0.54f;
    private static final float RING_REVERSAL_START_ROTATE_DURATION_OFFSET = 0.5f;
    private static final float RING_REVERSAL_END_ROTATE_DURATION_OFFSET = 0.75f;
    private static final float BALL_REVERSAL_START_ENTER_DURATION_OFFSET = 0.6f;
    private static final float BALL_REVERSAL_END_ENTER_DURATION_OFFSET = 0.725f;
    private static final float CENTER_CIRCLE_REVERSAL_START_SCALE_DURATION_OFFSET = 0.675f;
    private static final float CENTER_CIRCLE_REVERSAL_END_SCALE_DURATION_OFFSET = 0.875f;
    private static final float BALL_REVERSAL_START_EXIT_DURATION_OFFSET = 0.875f;
    private static final float BALL_REVERSAL_END_EXIT_DURATION_OFFSET = 1.0f;
    private final Paint mPaint = new Paint();
    private final RectF mTempBounds = new RectF();
    private final RectF mCurrentBounds = new RectF();
    private float mScale;
    private float mRotation;
    private float mStrokeInset;
    private float mCenterRadius;
    private float mStrokeWidth;
    private float mDanceBallRadius;
    private float mShapeChangeWidth;
    private float mShapeChangeHeight;
    private int mColor;
    private int mArcColor;

    private DanceLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
    }

    private void init(Context context) {
        this.mStrokeWidth = DensityUtil.dip2px(context, 1.5f);
        this.mCenterRadius = DensityUtil.dip2px(context, 12.5f);
        this.mDanceBallRadius = DensityUtil.dip2px(context, 2.0f);
        this.setColor(-1);
        this.setInsets((int)this.mWidth, (int)this.mHeight);
        this.mDuration = 1888L;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    protected void draw(Canvas canvas, Rect bounds) {
        int saveCount = canvas.save();
        this.mTempBounds.set(bounds);
        this.mTempBounds.inset(this.mStrokeInset, this.mStrokeInset);
        this.mCurrentBounds.set(this.mTempBounds);
        float outerCircleRadius = Math.min(this.mTempBounds.height(), this.mTempBounds.width()) / 2.0f;
        float interCircleRadius = outerCircleRadius / 2.0f;
        float centerRingWidth = interCircleRadius - this.mStrokeWidth / 2.0f;
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        canvas.drawCircle(this.mTempBounds.centerX(), this.mTempBounds.centerY(), outerCircleRadius, this.mPaint);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(this.mTempBounds.centerX(), this.mTempBounds.centerY(), interCircleRadius * this.mScale, this.mPaint);
        if (this.mRotation != 0.0f) {
            this.mPaint.setColor(this.mArcColor);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mTempBounds.inset(centerRingWidth / 2.0f + this.mStrokeWidth / 2.0f, centerRingWidth / 2.0f + this.mStrokeWidth / 2.0f);
            this.mPaint.setStrokeWidth(centerRingWidth);
            canvas.drawArc(this.mTempBounds, -90.0f, this.mRotation, false, this.mPaint);
        }
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        for (int i = 0; i < 3; ++i) {
            canvas.rotate((float)(i * 60), POINT_X[i], POINT_Y[i]);
            RectF rectF = new RectF(POINT_X[i] - this.mDanceBallRadius - this.mShapeChangeWidth / 2.0f, POINT_Y[i] - this.mDanceBallRadius - this.mShapeChangeHeight / 2.0f, POINT_X[i] + this.mDanceBallRadius + this.mShapeChangeWidth / 2.0f, POINT_Y[i] + this.mDanceBallRadius + this.mShapeChangeHeight / 2.0f);
            canvas.drawOval(rectF, this.mPaint);
            canvas.rotate((float)(-i * 60), POINT_X[i], POINT_Y[i]);
        }
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        float centerCircleScaleProgress;
        float progress;
        float k;
        int i;
        float radius = Math.min(this.mCurrentBounds.height(), this.mCurrentBounds.width()) / 2.0f;
        float originCoordinateX = this.mCurrentBounds.left;
        float originCoordinateY = this.mCurrentBounds.top + radius;
        if (renderProgress <= 0.125f && renderProgress > 0.0f) {
            float ballForwardEnterProgress = (renderProgress - 0.0f) / 0.125f;
            this.mShapeChangeHeight = (0.5f - ballForwardEnterProgress) * this.mDanceBallRadius / 2.0f;
            this.mShapeChangeWidth = -this.mShapeChangeHeight;
            i = 0;
            while (i < 3) {
                k = (float)Math.tan((double)((float)(0 + 60 * i) / 360.0f) * (Math.PI * 2));
                progress = (ACCELERATE_INTERPOLATOR.getInterpolation(ballForwardEnterProgress) / 2.0f - 0.5f) * 2.0f * (float)DIRECTION[i];
                DanceLoadingRenderer.POINT_X[i] = (float)((double)radius + (double)progress * ((double)radius / Math.sqrt(Math.pow(k, 2.0) + 1.0)));
                DanceLoadingRenderer.POINT_Y[i] = k * (POINT_X[i] - radius);
                int n = i;
                POINT_X[n] = POINT_X[n] + originCoordinateX;
                int n2 = i++;
                POINT_Y[n2] = POINT_Y[n2] + originCoordinateY;
            }
        }
        if (renderProgress <= 0.375f && renderProgress > 0.125f) {
            float forwardRotateProgress = (renderProgress - 0.125f) / 0.25f;
            this.mRotation = 360.0f * MATERIAL_INTERPOLATOR.getInterpolation(forwardRotateProgress);
        }
        if (renderProgress <= 0.475f && renderProgress > 0.225f) {
            centerCircleScaleProgress = (renderProgress - 0.225f) / 0.25f;
            this.mScale = centerCircleScaleProgress <= 0.5f ? 1.0f + DECELERATE_INTERPOLATOR.getInterpolation(centerCircleScaleProgress * 2.0f) * 0.2f : 1.2f - ACCELERATE_INTERPOLATOR.getInterpolation((centerCircleScaleProgress - 0.5f) * 2.0f) * 0.2f;
        }
        if (renderProgress <= 0.54f && renderProgress > 0.375f) {
            float ballForwardExitProgress = (renderProgress - 0.375f) / 0.16500002f;
            this.mShapeChangeHeight = (ballForwardExitProgress - 0.5f) * this.mDanceBallRadius / 2.0f;
            this.mShapeChangeWidth = -this.mShapeChangeHeight;
            i = 0;
            while (i < 3) {
                k = (float)Math.tan((double)((float)(0 + 60 * i) / 360.0f) * (Math.PI * 2));
                progress = DECELERATE_INTERPOLATOR.getInterpolation(ballForwardExitProgress) / 2.0f * 2.0f * (float)DIRECTION[i];
                DanceLoadingRenderer.POINT_X[i] = (float)((double)radius + (double)progress * ((double)radius / Math.sqrt(Math.pow(k, 2.0) + 1.0)));
                DanceLoadingRenderer.POINT_Y[i] = k * (POINT_X[i] - radius);
                int n = i;
                POINT_X[n] = POINT_X[n] + originCoordinateX;
                int n3 = i++;
                POINT_Y[n3] = POINT_Y[n3] + originCoordinateY;
            }
        }
        if (renderProgress <= 0.75f && renderProgress > 0.5f) {
            float scaledTime = (renderProgress - 0.5f) / 0.25f;
            this.mRotation = 360.0f * MATERIAL_INTERPOLATOR.getInterpolation(scaledTime) - 360.0f;
        } else if (renderProgress > 0.75f) {
            this.mRotation = 0.0f;
        }
        if (renderProgress <= 0.725f && renderProgress > 0.6f) {
            float ballReversalEnterProgress = (renderProgress - 0.6f) / 0.125f;
            this.mShapeChangeHeight = (0.5f - ballReversalEnterProgress) * this.mDanceBallRadius / 2.0f;
            this.mShapeChangeWidth = -this.mShapeChangeHeight;
            i = 0;
            while (i < 3) {
                k = (float)Math.tan((double)((float)(0 + 60 * i) / 360.0f) * (Math.PI * 2));
                progress = (0.5f - ACCELERATE_INTERPOLATOR.getInterpolation(ballReversalEnterProgress) / 2.0f) * 2.0f * (float)DIRECTION[i];
                DanceLoadingRenderer.POINT_X[i] = (float)((double)radius + (double)progress * ((double)radius / Math.sqrt(Math.pow(k, 2.0) + 1.0)));
                DanceLoadingRenderer.POINT_Y[i] = k * (POINT_X[i] - radius);
                int n = i;
                POINT_X[n] = POINT_X[n] + originCoordinateX;
                int n4 = i++;
                POINT_Y[n4] = POINT_Y[n4] + originCoordinateY;
            }
        }
        if (renderProgress <= 0.875f && renderProgress > 0.675f) {
            centerCircleScaleProgress = (renderProgress - 0.675f) / 0.19999999f;
            this.mScale = centerCircleScaleProgress <= 0.5f ? 1.0f + DECELERATE_INTERPOLATOR.getInterpolation(centerCircleScaleProgress * 2.0f) * 0.2f : 1.2f - ACCELERATE_INTERPOLATOR.getInterpolation((centerCircleScaleProgress - 0.5f) * 2.0f) * 0.2f;
        }
        if (renderProgress <= 1.0f && renderProgress > 0.875f) {
            float ballReversalExitProgress = (renderProgress - 0.875f) / 0.125f;
            this.mShapeChangeHeight = (ballReversalExitProgress - 0.5f) * this.mDanceBallRadius / 2.0f;
            this.mShapeChangeWidth = -this.mShapeChangeHeight;
            i = 0;
            while (i < 3) {
                k = (float)Math.tan((double)((float)(0 + 60 * i) / 360.0f) * (Math.PI * 2));
                progress = (0.0f - DECELERATE_INTERPOLATOR.getInterpolation(ballReversalExitProgress) / 2.0f) * 2.0f * (float)DIRECTION[i];
                DanceLoadingRenderer.POINT_X[i] = (float)((double)radius + (double)progress * ((double)radius / Math.sqrt(Math.pow(k, 2.0) + 1.0)));
                DanceLoadingRenderer.POINT_Y[i] = k * (POINT_X[i] - radius);
                int n = i;
                POINT_X[n] = POINT_X[n] + originCoordinateX;
                int n5 = i++;
                POINT_Y[n5] = POINT_Y[n5] + originCoordinateY;
            }
        }
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
        this.mScale = 1.0f;
        this.mRotation = 0.0f;
    }

    private void setColor(int color2) {
        this.mColor = color2;
        this.mArcColor = this.halfAlphaColor(this.mColor);
    }

    private void setRotation(float rotation) {
        this.mRotation = rotation;
    }

    private void setDanceBallRadius(float danceBallRadius) {
        this.mDanceBallRadius = danceBallRadius;
    }

    private float getDanceBallRadius() {
        return this.mDanceBallRadius;
    }

    private float getRotation() {
        return this.mRotation;
    }

    private void setInsets(int width, int height) {
        float minEdge = Math.min(width, height);
        float insets = this.mCenterRadius <= 0.0f || minEdge < 0.0f ? (float)Math.ceil(this.mStrokeWidth / 2.0f) : minEdge / 2.0f - this.mCenterRadius;
        this.mStrokeInset = insets;
    }

    private int halfAlphaColor(int colorValue) {
        int startA = colorValue >> 24 & 0xFF;
        int startR = colorValue >> 16 & 0xFF;
        int startG = colorValue >> 8 & 0xFF;
        int startB = colorValue & 0xFF;
        return startA / 2 << 24 | startR << 16 | startG << 8 | startB;
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public DanceLoadingRenderer build() {
            DanceLoadingRenderer loadingRenderer = new DanceLoadingRenderer(this.mContext);
            return loadingRenderer;
        }
    }
}

