/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.rotate;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.Interpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class MaterialLoadingRenderer
extends LoadingRenderer {
    private static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final int DEGREE_360 = 360;
    private static final int NUM_POINTS = 5;
    private static final float MAX_SWIPE_DEGREES = 288.0f;
    private static final float FULL_GROUP_ROTATION = 1080.0f;
    private static final float COLOR_START_DELAY_OFFSET = 0.8f;
    private static final float END_TRIM_DURATION_OFFSET = 1.0f;
    private static final float START_TRIM_DURATION_OFFSET = 0.5f;
    private static final float DEFAULT_CENTER_RADIUS = 12.5f;
    private static final float DEFAULT_STROKE_WIDTH = 2.5f;
    private static final int[] DEFAULT_COLORS = new int[]{-65536, -16711936, -16776961};
    private final Paint mPaint = new Paint();
    private final RectF mTempBounds = new RectF();
    private final Animator.AnimatorListener mAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationRepeat(Animator animator) {
            super.onAnimationRepeat(animator);
            MaterialLoadingRenderer.this.storeOriginals();
            MaterialLoadingRenderer.this.goToNextColor();
            MaterialLoadingRenderer.this.mStartDegrees = MaterialLoadingRenderer.this.mEndDegrees;
            MaterialLoadingRenderer.this.mRotationCount = (MaterialLoadingRenderer.this.mRotationCount + 1.0f) % 5.0f;
        }

        public void onAnimationStart(Animator animation) {
            super.onAnimationStart(animation);
            MaterialLoadingRenderer.this.mRotationCount = 0.0f;
        }
    };
    private int[] mColors;
    private int mColorIndex;
    private int mCurrentColor;
    private float mStrokeInset;
    private float mRotationCount;
    private float mGroupRotation;
    private float mEndDegrees;
    private float mStartDegrees;
    private float mSwipeDegrees;
    private float mOriginEndDegrees;
    private float mOriginStartDegrees;
    private float mStrokeWidth;
    private float mCenterRadius;

    private MaterialLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
        this.addRenderListener(this.mAnimatorListener);
    }

    private void init(Context context) {
        this.mStrokeWidth = DensityUtil.dip2px(context, 2.5f);
        this.mCenterRadius = DensityUtil.dip2px(context, 12.5f);
        this.mColors = DEFAULT_COLORS;
        this.setColorIndex(0);
        this.initStrokeInset(this.mWidth, this.mHeight);
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    @Override
    protected void draw(Canvas canvas) {
        int saveCount = canvas.save();
        this.mTempBounds.set(this.mBounds);
        this.mTempBounds.inset(this.mStrokeInset, this.mStrokeInset);
        canvas.rotate(this.mGroupRotation, this.mTempBounds.centerX(), this.mTempBounds.centerY());
        if (this.mSwipeDegrees != 0.0f) {
            this.mPaint.setColor(this.mCurrentColor);
            canvas.drawArc(this.mTempBounds, this.mStartDegrees, this.mSwipeDegrees, false, this.mPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        this.updateRingColor(renderProgress);
        if (renderProgress <= 0.5f) {
            float startTrimProgress = renderProgress / 0.5f;
            this.mStartDegrees = this.mOriginStartDegrees + 288.0f * MATERIAL_INTERPOLATOR.getInterpolation(startTrimProgress);
        }
        if (renderProgress > 0.5f) {
            float endTrimProgress = (renderProgress - 0.5f) / 0.5f;
            this.mEndDegrees = this.mOriginEndDegrees + 288.0f * MATERIAL_INTERPOLATOR.getInterpolation(endTrimProgress);
        }
        if (Math.abs(this.mEndDegrees - this.mStartDegrees) > 0.0f) {
            this.mSwipeDegrees = this.mEndDegrees - this.mStartDegrees;
        }
        this.mGroupRotation = 216.0f * renderProgress + 1080.0f * (this.mRotationCount / 5.0f);
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
        this.resetOriginals();
    }

    private void setColorIndex(int index) {
        this.mColorIndex = index;
        this.mCurrentColor = this.mColors[this.mColorIndex];
    }

    private int getNextColor() {
        return this.mColors[this.getNextColorIndex()];
    }

    private int getNextColorIndex() {
        return (this.mColorIndex + 1) % this.mColors.length;
    }

    private void goToNextColor() {
        this.setColorIndex(this.getNextColorIndex());
    }

    private void initStrokeInset(float width, float height) {
        float minStrokeInset;
        float minSize = Math.min(width, height);
        float strokeInset = minSize / 2.0f - this.mCenterRadius;
        this.mStrokeInset = strokeInset < (minStrokeInset = (float)Math.ceil(this.mStrokeWidth / 2.0f)) ? minStrokeInset : strokeInset;
    }

    private void storeOriginals() {
        this.mOriginEndDegrees = this.mEndDegrees;
        this.mOriginStartDegrees = this.mEndDegrees;
    }

    private void resetOriginals() {
        this.mOriginEndDegrees = 0.0f;
        this.mOriginStartDegrees = 0.0f;
        this.mEndDegrees = 0.0f;
        this.mStartDegrees = 0.0f;
    }

    private int getStartingColor() {
        return this.mColors[this.mColorIndex];
    }

    private void updateRingColor(float interpolatedTime) {
        if (interpolatedTime > 0.8f) {
            this.mCurrentColor = this.evaluateColorChange((interpolatedTime - 0.8f) / 0.19999999f, this.getStartingColor(), this.getNextColor());
        }
    }

    private int evaluateColorChange(float fraction, int startValue, int endValue) {
        int startA = startValue >> 24 & 0xFF;
        int startR = startValue >> 16 & 0xFF;
        int startG = startValue >> 8 & 0xFF;
        int startB = startValue & 0xFF;
        int endA = endValue >> 24 & 0xFF;
        int endR = endValue >> 16 & 0xFF;
        int endG = endValue >> 8 & 0xFF;
        int endB = endValue & 0xFF;
        return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
    }

    private void apply(Builder builder) {
        this.mWidth = builder.mWidth > 0 ? (float)builder.mWidth : this.mWidth;
        this.mHeight = builder.mHeight > 0 ? (float)builder.mHeight : this.mHeight;
        this.mStrokeWidth = builder.mStrokeWidth > 0 ? (float)builder.mStrokeWidth : this.mStrokeWidth;
        this.mCenterRadius = builder.mCenterRadius > 0 ? (float)builder.mCenterRadius : this.mCenterRadius;
        this.mDuration = builder.mDuration > 0 ? (long)builder.mDuration : this.mDuration;
        this.mColors = builder.mColors != null && builder.mColors.length > 0 ? builder.mColors : this.mColors;
        this.setColorIndex(0);
        this.setupPaint();
        this.initStrokeInset(this.mWidth, this.mHeight);
    }

    public static class Builder {
        private Context mContext;
        private int mWidth;
        private int mHeight;
        private int mStrokeWidth;
        private int mCenterRadius;
        private int mDuration;
        private int[] mColors;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder setStrokeWidth(int strokeWidth) {
            this.mStrokeWidth = strokeWidth;
            return this;
        }

        public Builder setCenterRadius(int centerRadius) {
            this.mCenterRadius = centerRadius;
            return this;
        }

        public Builder setDuration(int duration) {
            this.mDuration = duration;
            return this;
        }

        public Builder setColors(int[] colors) {
            this.mColors = colors;
            return this;
        }

        public MaterialLoadingRenderer build() {
            MaterialLoadingRenderer loadingRenderer = new MaterialLoadingRenderer(this.mContext);
            loadingRenderer.apply(this);
            return loadingRenderer;
        }
    }
}

