/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.scenery;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ElectricFanLoadingRenderer
extends LoadingRenderer {
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator FASTOUTLINEARIN_INTERPOLATOR = new FastOutLinearInInterpolator();
    private static final Interpolator[] INTERPOLATORS = new Interpolator[]{LINEAR_INTERPOLATOR, DECELERATE_INTERPOLATOR, ACCELERATE_INTERPOLATOR, FASTOUTLINEARIN_INTERPOLATOR, MATERIAL_INTERPOLATOR};
    private static final List<LeafHolder> mLeafHolders = new ArrayList<LeafHolder>();
    private static final Random mRandom = new Random();
    private final Animator.AnimatorListener mAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationRepeat(Animator animator) {
            super.onAnimationRepeat(animator);
            ElectricFanLoadingRenderer.this.reset();
        }
    };
    public static final int MODE_NORMAL = 0;
    public static final int MODE_LEAF_COUNT = 1;
    private static final String PERCENTAGE_100 = "100%";
    private static final long ANIMATION_DURATION = 20000L;
    private static final int LEAF_COUNT = 28;
    private static final int DEGREE_180 = 180;
    private static final int DEGREE_360 = 360;
    private static final int FULL_GROUP_ROTATION = 1890;
    private static final int DEFAULT_PROGRESS_COLOR = -219346;
    private static final int DEFAULT_PROGRESS_BGCOLOR = -207713;
    private static final int DEFAULT_ELECTRIC_FAN_BGCOLOR = -209831;
    private static final int DEFAULT_ELECTRIC_FAN_OUTLINE_COLOR = -1;
    private static final float DEFAULT_WIDTH = 182.0f;
    private static final float DEFAULT_HEIGHT = 65.0f;
    private static final float DEFAULT_TEXT_SIZE = 11.0f;
    private static final float DEFAULT_STROKE_WIDTH = 2.0f;
    private static final float DEFAULT_STROKE_INTERVAL = 0.2f;
    private static final float DEFAULT_CENTER_RADIUS = 16.0f;
    private static final float DEFAULT_PROGRESS_CENTER_RADIUS = 11.0f;
    private static final float DEFAULT_LEAF_FLY_DURATION_FACTOR = 0.1f;
    private static final float LEAF_CREATE_DURATION_INTERVAL = 0.035714287f;
    private static final float DECELERATE_DURATION_PERCENTAGE = 0.4f;
    private static final float ACCELERATE_DURATION_PERCENTAGE = 0.6f;
    private final Paint mPaint = new Paint();
    private final RectF mTempBounds = new RectF();
    private final RectF mCurrentProgressBounds = new RectF();
    private float mTextSize;
    private float mStrokeXInset;
    private float mStrokeYInset;
    private float mProgressCenterRadius;
    private float mScale;
    private float mRotation;
    private float mProgress;
    private float mNextLeafCreateThreshold;
    private int mProgressColor;
    private int mProgressBgColor;
    private int mElectricFanBgColor;
    private int mElectricFanOutlineColor;
    private float mStrokeWidth;
    private float mCenterRadius;
    private int mMode;
    private int mCurrentLeafCount;
    private Drawable mLeafDrawable;
    private Drawable mLoadingDrawable;
    private Drawable mElectricFanDrawable;

    private ElectricFanLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
    }

    private void init(Context context) {
        this.mMode = 0;
        this.mWidth = DensityUtil.dip2px(context, 182.0f);
        this.mHeight = DensityUtil.dip2px(context, 65.0f);
        this.mTextSize = DensityUtil.dip2px(context, 11.0f);
        this.mStrokeWidth = DensityUtil.dip2px(context, 2.0f);
        this.mCenterRadius = DensityUtil.dip2px(context, 16.0f);
        this.mProgressCenterRadius = DensityUtil.dip2px(context, 11.0f);
        this.mProgressColor = -219346;
        this.mProgressBgColor = -207713;
        this.mElectricFanBgColor = -209831;
        this.mElectricFanOutlineColor = -1;
        this.mLeafDrawable = context.getResources().getDrawable(R.drawable.ic_leaf);
        this.mLoadingDrawable = context.getResources().getDrawable(R.drawable.ic_loading);
        this.mElectricFanDrawable = context.getResources().getDrawable(R.drawable.ic_eletric_fan);
        this.mDuration = 20000L;
        this.setInsets((int)this.mWidth, (int)this.mHeight);
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    @Override
    protected void draw(Canvas canvas, Rect bounds) {
        int saveCount = canvas.save();
        RectF arcBounds = this.mTempBounds;
        arcBounds.set(bounds);
        arcBounds.inset(this.mStrokeXInset, this.mStrokeYInset);
        this.mCurrentProgressBounds.set(arcBounds.left, arcBounds.bottom - 2.0f * this.mCenterRadius, arcBounds.right, arcBounds.bottom);
        this.mLoadingDrawable.setBounds((int)arcBounds.centerX() - this.mLoadingDrawable.getIntrinsicWidth() / 2, 0, (int)arcBounds.centerX() + this.mLoadingDrawable.getIntrinsicWidth() / 2, this.mLoadingDrawable.getIntrinsicHeight());
        this.mLoadingDrawable.draw(canvas);
        float progressInset = this.mCenterRadius - this.mProgressCenterRadius;
        RectF progressRect = new RectF(this.mCurrentProgressBounds);
        progressRect.inset(progressInset - 0.2f, progressInset - 0.2f);
        this.mPaint.setColor(this.mProgressBgColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(progressRect, this.mProgressCenterRadius, this.mProgressCenterRadius, this.mPaint);
        this.mPaint.setColor(this.mProgressColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.createProgressPath(this.mProgress, this.mProgressCenterRadius, progressRect), this.mPaint);
        for (int i = 0; i < mLeafHolders.size(); ++i) {
            int leafSaveCount = canvas.save();
            LeafHolder leafHolder = mLeafHolders.get(i);
            Rect leafBounds = leafHolder.mLeafRect;
            canvas.rotate(leafHolder.mLeafRotation, (float)leafBounds.centerX(), (float)leafBounds.centerY());
            this.mLeafDrawable.setBounds(leafBounds);
            this.mLeafDrawable.draw(canvas);
            canvas.restoreToCount(leafSaveCount);
        }
        RectF progressOutlineRect = new RectF(this.mCurrentProgressBounds);
        float progressOutlineStrokeInset = (this.mCenterRadius - this.mProgressCenterRadius) / 2.0f;
        progressOutlineRect.inset(progressOutlineStrokeInset, progressOutlineStrokeInset);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mProgressBgColor);
        this.mPaint.setStrokeWidth(this.mCenterRadius - this.mProgressCenterRadius);
        canvas.drawRoundRect(progressOutlineRect, this.mCenterRadius, this.mCenterRadius, this.mPaint);
        float electricFanCenterX = arcBounds.right - this.mCenterRadius;
        float electricFanCenterY = arcBounds.bottom - this.mCenterRadius;
        this.mPaint.setColor(this.mElectricFanOutlineColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        canvas.drawCircle(arcBounds.right - this.mCenterRadius, arcBounds.bottom - this.mCenterRadius, this.mCenterRadius - this.mStrokeWidth / 2.0f, this.mPaint);
        this.mPaint.setColor(this.mElectricFanBgColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(arcBounds.right - this.mCenterRadius, arcBounds.bottom - this.mCenterRadius, this.mCenterRadius - this.mStrokeWidth + 0.2f, this.mPaint);
        int rotateSaveCount = canvas.save();
        canvas.rotate(this.mRotation, electricFanCenterX, electricFanCenterY);
        this.mElectricFanDrawable.setBounds((int)(electricFanCenterX - (float)(this.mElectricFanDrawable.getIntrinsicWidth() / 2) * this.mScale), (int)(electricFanCenterY - (float)(this.mElectricFanDrawable.getIntrinsicHeight() / 2) * this.mScale), (int)(electricFanCenterX + (float)(this.mElectricFanDrawable.getIntrinsicWidth() / 2) * this.mScale), (int)(electricFanCenterY + (float)(this.mElectricFanDrawable.getIntrinsicHeight() / 2) * this.mScale));
        this.mElectricFanDrawable.draw(canvas);
        canvas.restoreToCount(rotateSaveCount);
        if (this.mScale < 1.0f) {
            this.mPaint.setTextSize(this.mTextSize * (1.0f - this.mScale));
            this.mPaint.setColor(this.mElectricFanOutlineColor);
            Rect textRect = new Rect();
            this.mPaint.getTextBounds(PERCENTAGE_100, 0, PERCENTAGE_100.length(), textRect);
            canvas.drawText(PERCENTAGE_100, electricFanCenterX - (float)textRect.width() / 2.0f, electricFanCenterY + (float)textRect.height() / 2.0f, this.mPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    private Path createProgressPath(float progress, float circleRadius, RectF progressRect) {
        RectF arcProgressRect = new RectF(progressRect.left, progressRect.top, progressRect.left + circleRadius * 2.0f, progressRect.bottom);
        RectF rectProgressRect = null;
        float progressWidth = progress * progressRect.width();
        float progressModeWidth = this.mMode == 1 ? (float)this.mCurrentLeafCount / 28.0f * progressRect.width() : progress * progressRect.width();
        float swipeAngle = 180.0f;
        if (progressModeWidth < circleRadius) {
            swipeAngle = progressModeWidth / circleRadius * 180.0f;
        }
        if (progressModeWidth < progressRect.width() - circleRadius && progressModeWidth >= circleRadius) {
            rectProgressRect = new RectF(progressRect.left + circleRadius, progressRect.top, progressRect.left + progressModeWidth, progressRect.bottom);
        }
        if (progressWidth >= progressRect.width() - circleRadius) {
            rectProgressRect = new RectF(progressRect.left + circleRadius, progressRect.top, progressRect.right - circleRadius, progressRect.bottom);
            this.mScale = (progressRect.width() - progressWidth) / circleRadius;
        }
        if (progressWidth < progressRect.width() - circleRadius) {
            this.mRotation = progressWidth / (progressRect.width() - circleRadius) * 1890.0f % 360.0f;
            RectF leafRect = new RectF(progressRect.left + progressWidth, progressRect.top, progressRect.right - circleRadius, progressRect.bottom);
            this.addLeaf(progress, leafRect);
        }
        Path path = new Path();
        path.addArc(arcProgressRect, 180.0f - swipeAngle / 2.0f, swipeAngle);
        if (rectProgressRect != null) {
            path.addRect(rectProgressRect, Path.Direction.CW);
        }
        return path;
    }

    @Override
    protected void computeRender(float renderProgress) {
        this.mProgress = renderProgress < 0.4f ? DECELERATE_INTERPOLATOR.getInterpolation(renderProgress / 0.4f) * 0.4f : ACCELERATE_INTERPOLATOR.getInterpolation((renderProgress - 0.4f) / 0.6f) * 0.6f + 0.4f;
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
        this.mScale = 1.0f;
        this.mCurrentLeafCount = 0;
        this.mNextLeafCreateThreshold = 0.0f;
        mLeafHolders.clear();
    }

    protected void setInsets(int width, int height) {
        float minEdge = Math.min(width, height);
        float insetXs = this.mCenterRadius <= 0.0f || minEdge < 0.0f ? (float)Math.ceil(this.mCenterRadius / 2.0f) : this.mCenterRadius;
        this.mStrokeYInset = (float)Math.ceil(this.mCenterRadius / 2.0f);
        this.mStrokeXInset = insetXs;
    }

    private void addLeaf(float progress, RectF leafFlyRect) {
        if (progress < this.mNextLeafCreateThreshold) {
            return;
        }
        this.mNextLeafCreateThreshold += 0.035714287f;
        LeafHolder leafHolder = new LeafHolder();
        mLeafHolders.add(leafHolder);
        Animator leafAnimator = this.getAnimator(leafHolder, leafFlyRect, progress);
        leafAnimator.addListener((Animator.AnimatorListener)new AnimEndListener(leafHolder));
        leafAnimator.start();
    }

    private Animator getAnimator(LeafHolder target, RectF leafFlyRect, float progress) {
        ValueAnimator bezierValueAnimator = this.getBezierValueAnimator(target, leafFlyRect, progress);
        AnimatorSet finalSet = new AnimatorSet();
        finalSet.playSequentially(new Animator[]{bezierValueAnimator});
        finalSet.setInterpolator((TimeInterpolator)INTERPOLATORS[mRandom.nextInt(INTERPOLATORS.length)]);
        finalSet.setTarget((Object)target);
        return finalSet;
    }

    private ValueAnimator getBezierValueAnimator(LeafHolder target, RectF leafFlyRect, float progress) {
        BezierEvaluator evaluator = new BezierEvaluator(this.getPoint1(leafFlyRect), this.getPoint2(leafFlyRect));
        int leafFlyStartY = (int)(this.mCurrentProgressBounds.bottom - (float)this.mLeafDrawable.getIntrinsicHeight());
        int leafFlyRange = (int)(this.mCurrentProgressBounds.height() - (float)this.mLeafDrawable.getIntrinsicHeight());
        int startPointY = leafFlyStartY - mRandom.nextInt(leafFlyRange);
        int endPointY = leafFlyStartY - mRandom.nextInt(leafFlyRange);
        ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)evaluator, (Object[])new Object[]{new PointF((float)((int)(leafFlyRect.right - (float)this.mLeafDrawable.getIntrinsicWidth())), (float)startPointY), new PointF(leafFlyRect.left, (float)endPointY)});
        animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new BezierListener(target));
        animator.setTarget((Object)target);
        animator.setDuration((long)(((float)mRandom.nextInt(300) + (float)this.mDuration * 0.1f) * (1.0f - progress)));
        return animator;
    }

    private PointF getPoint1(RectF leafFlyRect) {
        PointF point = new PointF();
        point.x = leafFlyRect.right - (float)mRandom.nextInt((int)(leafFlyRect.width() / 2.0f));
        point.y = (int)(leafFlyRect.bottom - (float)mRandom.nextInt((int)leafFlyRect.height()));
        return point;
    }

    private PointF getPoint2(RectF leafFlyRect) {
        PointF point = new PointF();
        point.x = leafFlyRect.left + (float)mRandom.nextInt((int)(leafFlyRect.width() / 2.0f));
        point.y = (int)(leafFlyRect.bottom - (float)mRandom.nextInt((int)leafFlyRect.height()));
        return point;
    }

    static /* synthetic */ Random access$400() {
        return mRandom;
    }

    private class LeafHolder {
        public Rect mLeafRect = new Rect();
        public float mLeafRotation = 0.0f;
        public float mMaxRotation = ElectricFanLoadingRenderer.access$400().nextInt(120);

        private LeafHolder() {
        }
    }

    private class AnimEndListener
    extends AnimatorListenerAdapter {
        private LeafHolder target;

        public AnimEndListener(LeafHolder target) {
            this.target = target;
        }

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            mLeafHolders.remove(this.target);
            ElectricFanLoadingRenderer.this.mCurrentLeafCount++;
        }
    }

    private class BezierEvaluator
    implements TypeEvaluator<PointF> {
        private PointF point1;
        private PointF point2;

        public BezierEvaluator(PointF point1, PointF point2) {
            this.point1 = point1;
            this.point2 = point2;
        }

        public PointF evaluate(float fraction, PointF point0, PointF point3) {
            float t = fraction;
            float tLeft = 1.0f - t;
            float x = (float)((double)point0.x * Math.pow(tLeft, 3.0) + (double)(3.0f * this.point1.x * t) * Math.pow(tLeft, 2.0) + (double)(3.0f * this.point2.x) * Math.pow(t, 2.0) * (double)tLeft + (double)point3.x * Math.pow(t, 3.0));
            float y = (float)((double)point0.y * Math.pow(tLeft, 3.0) + (double)(3.0f * this.point1.y * t) * Math.pow(tLeft, 2.0) + (double)(3.0f * this.point2.y) * Math.pow(t, 2.0) * (double)tLeft + (double)point3.y * Math.pow(t, 3.0));
            return new PointF(x, y);
        }
    }

    private class BezierListener
    implements ValueAnimator.AnimatorUpdateListener {
        private LeafHolder target;

        public BezierListener(LeafHolder target) {
            this.target = target;
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            PointF point = (PointF)animation.getAnimatedValue();
            this.target.mLeafRect.set((int)point.x, (int)point.y, (int)(point.x + (float)ElectricFanLoadingRenderer.this.mLeafDrawable.getIntrinsicWidth()), (int)(point.y + (float)ElectricFanLoadingRenderer.this.mLeafDrawable.getIntrinsicHeight()));
            this.target.mLeafRotation = this.target.mMaxRotation * animation.getAnimatedFraction();
        }
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public ElectricFanLoadingRenderer build() {
            ElectricFanLoadingRenderer loadingRenderer = new ElectricFanLoadingRenderer(this.mContext);
            return loadingRenderer;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MODE {
    }
}

