/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.shapechange;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class CoolWaitLoadingRenderer
extends LoadingRenderer {
    private final Interpolator ACCELERATE_INTERPOLATOR08 = new AccelerateInterpolator(0.8f);
    private final Interpolator ACCELERATE_INTERPOLATOR10 = new AccelerateInterpolator(1.0f);
    private final Interpolator ACCELERATE_INTERPOLATOR15 = new AccelerateInterpolator(1.5f);
    private final Interpolator DECELERATE_INTERPOLATOR03 = new DecelerateInterpolator(0.3f);
    private final Interpolator DECELERATE_INTERPOLATOR05 = new DecelerateInterpolator(0.5f);
    private final Interpolator DECELERATE_INTERPOLATOR08 = new DecelerateInterpolator(0.8f);
    private final Interpolator DECELERATE_INTERPOLATOR10 = new DecelerateInterpolator(1.0f);
    private static final Interpolator ACCELERATE_DECELERATE_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private final float DEFAULT_WIDTH = 200.0f;
    private final float DEFAULT_HEIGHT = 150.0f;
    private final float DEFAULT_STROKE_WIDTH = 8.0f;
    private final float WAIT_CIRCLE_RADIUS = 50.0f;
    private static final float WAIT_TRIM_DURATION_OFFSET = 0.5f;
    private static final float END_TRIM_DURATION_OFFSET = 1.0f;
    private final long ANIMATION_DURATION = 2222L;
    private final Paint mPaint = new Paint();
    private final Path mWaitPath = new Path();
    private final Path mCurrentTopWaitPath = new Path();
    private final Path mCurrentMiddleWaitPath = new Path();
    private final Path mCurrentBottomWaitPath = new Path();
    private final PathMeasure mWaitPathMeasure = new PathMeasure();
    private final RectF mCurrentBounds = new RectF();
    private float mStrokeWidth;
    private float mWaitCircleRadius;
    private float mOriginEndDistance;
    private float mOriginStartDistance;
    private float mWaitPathLength;
    private int mTopColor;
    private int mMiddleColor;
    private int mBottomColor;

    private CoolWaitLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
    }

    private void init(Context context) {
        this.mWidth = DensityUtil.dip2px(context, 200.0f);
        this.mHeight = DensityUtil.dip2px(context, 150.0f);
        this.mStrokeWidth = DensityUtil.dip2px(context, 8.0f);
        this.mWaitCircleRadius = DensityUtil.dip2px(context, 50.0f);
        this.mTopColor = -1;
        this.mMiddleColor = Color.parseColor((String)"#FFF3C742");
        this.mBottomColor = Color.parseColor((String)"#FF89CC59");
        this.mDuration = 2222L;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    @Override
    protected void draw(Canvas canvas, Rect bounds) {
        int saveCount = canvas.save();
        RectF arcBounds = this.mCurrentBounds;
        arcBounds.set(bounds);
        this.mPaint.setColor(this.mBottomColor);
        canvas.drawPath(this.mCurrentBottomWaitPath, this.mPaint);
        this.mPaint.setColor(this.mMiddleColor);
        canvas.drawPath(this.mCurrentMiddleWaitPath, this.mPaint);
        this.mPaint.setColor(this.mTopColor);
        canvas.drawPath(this.mCurrentTopWaitPath, this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    private Path createWaitPath(RectF bounds) {
        Path path = new Path();
        path.moveTo(bounds.centerX() + this.mWaitCircleRadius, bounds.centerY());
        path.cubicTo(bounds.centerX() + this.mWaitCircleRadius, bounds.centerY() - this.mWaitCircleRadius * 0.5f, bounds.centerX() + this.mWaitCircleRadius * 0.3f, bounds.centerY() - this.mWaitCircleRadius, bounds.centerX() - this.mWaitCircleRadius * 0.35f, bounds.centerY() + this.mWaitCircleRadius * 0.5f);
        path.quadTo(bounds.centerX() + this.mWaitCircleRadius, bounds.centerY() - this.mWaitCircleRadius, bounds.centerX() + this.mWaitCircleRadius * 0.05f, bounds.centerY() + this.mWaitCircleRadius * 0.5f);
        path.lineTo(bounds.centerX() + this.mWaitCircleRadius * 0.75f, bounds.centerY() - this.mWaitCircleRadius * 0.2f);
        path.cubicTo(bounds.centerX(), bounds.centerY() + this.mWaitCircleRadius * 1.0f, bounds.centerX() + this.mWaitCircleRadius, bounds.centerY() + this.mWaitCircleRadius * 0.4f, bounds.centerX() + this.mWaitCircleRadius, bounds.centerY());
        path.arcTo(new RectF(bounds.centerX() - this.mWaitCircleRadius, bounds.centerY() - this.mWaitCircleRadius, bounds.centerX() + this.mWaitCircleRadius, bounds.centerY() + this.mWaitCircleRadius), 0.0f, -359.0f);
        path.arcTo(new RectF(bounds.centerX() - this.mWaitCircleRadius, bounds.centerY() - this.mWaitCircleRadius, bounds.centerX() + this.mWaitCircleRadius, bounds.centerY() + this.mWaitCircleRadius), 1.0f, -359.0f);
        path.arcTo(new RectF(bounds.centerX() - this.mWaitCircleRadius, bounds.centerY() - this.mWaitCircleRadius, bounds.centerX() + this.mWaitCircleRadius, bounds.centerY() + this.mWaitCircleRadius), 2.0f, -2.0f);
        path.cubicTo(bounds.centerX() + this.mWaitCircleRadius, bounds.centerY() - this.mWaitCircleRadius * 0.5f, bounds.centerX() + this.mWaitCircleRadius * 0.3f, bounds.centerY() - this.mWaitCircleRadius, bounds.centerX() - this.mWaitCircleRadius * 0.35f, bounds.centerY() + this.mWaitCircleRadius * 0.5f);
        path.quadTo(bounds.centerX() + this.mWaitCircleRadius, bounds.centerY() - this.mWaitCircleRadius, bounds.centerX() + this.mWaitCircleRadius * 0.05f, bounds.centerY() + this.mWaitCircleRadius * 0.5f);
        path.lineTo(bounds.centerX() + this.mWaitCircleRadius * 0.75f, bounds.centerY() - this.mWaitCircleRadius * 0.2f);
        path.cubicTo(bounds.centerX(), bounds.centerY() + this.mWaitCircleRadius * 1.0f, bounds.centerX() + this.mWaitCircleRadius, bounds.centerY() + this.mWaitCircleRadius * 0.4f, bounds.centerX() + this.mWaitCircleRadius, bounds.centerY());
        return path;
    }

    @Override
    protected void computeRender(float renderProgress) {
        float bottomStartDistance;
        float bottomEndDistance;
        float bottomEndTrimProgress;
        float bottomStartTrimProgress;
        float middleStartDistance;
        float middleEndDistance;
        float middleEndTrimProgress;
        float middleStartTrimProgress;
        float topStartDistance;
        float topEndDistance;
        if (this.mCurrentBounds.isEmpty()) {
            return;
        }
        if (this.mWaitPath.isEmpty()) {
            this.mWaitPath.set(this.createWaitPath(this.mCurrentBounds));
            this.mWaitPathMeasure.setPath(this.mWaitPath, false);
            this.mWaitPathLength = this.mWaitPathMeasure.getLength();
            this.mOriginEndDistance = this.mWaitPathLength * 0.255f;
            this.mOriginStartDistance = this.mWaitPathLength * 0.045f;
        }
        this.mCurrentTopWaitPath.reset();
        this.mCurrentMiddleWaitPath.reset();
        this.mCurrentBottomWaitPath.reset();
        if (renderProgress <= 0.5f) {
            float topTrimProgress = ACCELERATE_DECELERATE_INTERPOLATOR.getInterpolation(renderProgress / 0.5f);
            topEndDistance = this.mOriginEndDistance + this.mWaitPathLength * 0.3f * topTrimProgress;
            topStartDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.48f * topTrimProgress;
            this.mWaitPathMeasure.getSegment(topStartDistance, topEndDistance, this.mCurrentTopWaitPath, true);
        }
        if (renderProgress > 0.01f && renderProgress <= 0.375f) {
            middleStartTrimProgress = this.ACCELERATE_INTERPOLATOR10.getInterpolation((renderProgress - 0.01f) / 0.365f);
            middleEndTrimProgress = this.DECELERATE_INTERPOLATOR08.getInterpolation((renderProgress - 0.01f) / 0.365f);
            middleEndDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.42f * middleEndTrimProgress;
            middleStartDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.42f * middleStartTrimProgress;
            this.mWaitPathMeasure.getSegment(middleStartDistance, middleEndDistance, this.mCurrentMiddleWaitPath, true);
        }
        if (renderProgress > 0.02f && renderProgress <= 0.375f) {
            bottomStartTrimProgress = this.ACCELERATE_INTERPOLATOR15.getInterpolation((renderProgress - 0.02f) / 0.355f);
            bottomEndTrimProgress = this.DECELERATE_INTERPOLATOR05.getInterpolation((renderProgress - 0.02f) / 0.355f);
            bottomEndDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.42f * bottomEndTrimProgress;
            bottomStartDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.42f * bottomStartTrimProgress;
            this.mWaitPathMeasure.getSegment(bottomStartDistance, bottomEndDistance, this.mCurrentBottomWaitPath, true);
        }
        if (renderProgress <= 1.0f && renderProgress > 0.5f) {
            float trimProgress = ACCELERATE_DECELERATE_INTERPOLATOR.getInterpolation((renderProgress - 0.5f) / 0.5f);
            topEndDistance = this.mOriginEndDistance + this.mWaitPathLength * 0.3f + this.mWaitPathLength * 0.45f * trimProgress;
            topStartDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.48f + this.mWaitPathLength * 0.27f * trimProgress;
            this.mWaitPathMeasure.getSegment(topStartDistance, topEndDistance, this.mCurrentTopWaitPath, true);
        }
        if (renderProgress > 0.51f && renderProgress <= 0.81f) {
            middleStartTrimProgress = this.ACCELERATE_INTERPOLATOR08.getInterpolation((renderProgress - 0.5f - 0.01f) / 0.3f);
            middleEndTrimProgress = this.DECELERATE_INTERPOLATOR03.getInterpolation((renderProgress - 0.5f - 0.01f) / 0.3f);
            middleEndDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.48f + this.mWaitPathLength * 0.2f * middleEndTrimProgress;
            middleStartDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.48f + this.mWaitPathLength * 0.1f * middleStartTrimProgress;
            this.mWaitPathMeasure.getSegment(middleStartDistance, middleEndDistance, this.mCurrentMiddleWaitPath, true);
        }
        if (renderProgress > 0.81f && renderProgress <= 1.0f) {
            middleStartTrimProgress = this.DECELERATE_INTERPOLATOR10.getInterpolation((renderProgress - 0.5f - 0.31f) / 0.19f);
            middleEndTrimProgress = this.DECELERATE_INTERPOLATOR03.getInterpolation((renderProgress - 0.5f - 0.31f) / 0.19f);
            middleEndDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.68f + this.mWaitPathLength * 0.325f * middleEndTrimProgress;
            middleStartDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.58f + this.mWaitPathLength * 0.17f * middleStartTrimProgress;
            this.mWaitPathMeasure.getSegment(middleStartDistance, middleEndDistance, this.mCurrentMiddleWaitPath, true);
        }
        if (renderProgress > 0.55f && renderProgress <= 0.85f) {
            bottomStartTrimProgress = this.ACCELERATE_INTERPOLATOR15.getInterpolation((renderProgress - 0.5f - 0.05f) / 0.3f);
            bottomEndTrimProgress = this.DECELERATE_INTERPOLATOR03.getInterpolation((renderProgress - 0.5f - 0.05f) / 0.3f);
            bottomEndDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.48f + this.mWaitPathLength * 0.2f * bottomEndTrimProgress;
            bottomStartDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.48f + this.mWaitPathLength * 0.1f * bottomStartTrimProgress;
            this.mWaitPathMeasure.getSegment(bottomStartDistance, bottomEndDistance, this.mCurrentBottomWaitPath, true);
        }
        if (renderProgress > 0.85f && renderProgress <= 1.0f) {
            bottomStartTrimProgress = this.DECELERATE_INTERPOLATOR05.getInterpolation((renderProgress - 0.5f - 0.35f) / 0.15f);
            bottomEndTrimProgress = this.DECELERATE_INTERPOLATOR03.getInterpolation((renderProgress - 0.5f - 0.35f) / 0.15f);
            bottomEndDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.68f + this.mWaitPathLength * 0.325f * bottomEndTrimProgress;
            bottomStartDistance = this.mOriginStartDistance + this.mWaitPathLength * 0.58f + this.mWaitPathLength * 0.17f * bottomStartTrimProgress;
            this.mWaitPathMeasure.getSegment(bottomStartDistance, bottomEndDistance, this.mCurrentBottomWaitPath, true);
        }
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public CoolWaitLoadingRenderer build() {
            CoolWaitLoadingRenderer loadingRenderer = new CoolWaitLoadingRenderer(this.mContext);
            return loadingRenderer;
        }
    }
}

