/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.ui;

import android.app.Activity;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.taiyi.typulse.ResultListener;
import com.taiyi.typulse.TaiyiManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class TYUsbDeviceActivity
extends Activity {
    private static final String TAG = "TYUsbDeviceActivity";
    private UsbManager usbManager;
    private UsbDevice connectedDevice;
    private List<Integer> recentData = new ArrayList<Integer>();
    private StringBuilder csvData = new StringBuilder();
    private boolean isMeasuring = false;
    private long measureTime = 0L;
    private Timer measureTimer;
    private Handler mainHandler;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.usbManager = (UsbManager)this.getSystemService("usb");
        Log.d((String)TAG, (String)"TYUsbDeviceActivity\u521b\u5efa");
        this.csvData.append("\u65f6\u95f4\u6233,\u5fc3\u7387\u6570\u636e,\u8840\u538b\u6570\u636e,\u8840\u6c27\u6570\u636e\n");
    }

    protected void checkUsbConnection() {
        HashMap deviceList = this.usbManager.getDeviceList();
        for (UsbDevice device : deviceList.values()) {
            Log.d((String)TAG, (String)("\u53d1\u73b0USB\u8bbe\u5907: " + device.getDeviceName() + ", VID: " + device.getVendorId() + ", PID: " + device.getProductId()));
            if (device.getVendorId() != 1234 || device.getProductId() != 5678) continue;
            this.connectedDevice = device;
            Log.d((String)TAG, (String)"\u627e\u5230\u76ee\u6807USB\u8bbe\u5907");
            break;
        }
        if (this.connectedDevice == null) {
            Log.w((String)TAG, (String)"\u672a\u627e\u5230\u76ee\u6807USB\u8bbe\u5907");
        }
    }

    protected void startMeasure() {
        if (this.isMeasuring) {
            Log.w((String)TAG, (String)"\u6d4b\u91cf\u5df2\u5728\u8fdb\u884c\u4e2d");
            return;
        }
        this.isMeasuring = true;
        this.measureTime = System.currentTimeMillis();
        this.recentData.clear();
        Log.d((String)TAG, (String)"\u5f00\u59cb\u6d4b\u91cf");
        this.measureTimer = new Timer();
        this.measureTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TYUsbDeviceActivity.this.simulateDataReceive();
            }
        }, 0L, 100L);
        this.mainHandler.postDelayed(() -> this.stopMeasure(), 30000L);
    }

    private void simulateDataReceive() {
        int heartRate = 60 + (int)(Math.random() * 40.0);
        int systolic = 110 + (int)(Math.random() * 30.0);
        int diastolic = 70 + (int)(Math.random() * 20.0);
        int oxygenSaturation = 95 + (int)(Math.random() * 5.0);
        this.onReceiveMaiData(heartRate, systolic, diastolic, oxygenSaturation);
    }

    protected void onReceiveMaiData(int heartRate, int systolic, int diastolic, int oxygenSaturation) {
        this.recentData.add(heartRate);
        if (this.recentData.size() > 100) {
            this.recentData.remove(0);
        }
        long currentTime = System.currentTimeMillis();
        this.csvData.append(currentTime).append(",").append(heartRate).append(",").append(systolic).append("/").append(diastolic).append(",").append(oxygenSaturation).append("\n");
        Log.d((String)TAG, (String)("\u63a5\u6536\u6570\u636e - \u5fc3\u7387: " + heartRate + ", \u8840\u538b: " + systolic + "/" + diastolic + ", \u8840\u6c27: " + oxygenSaturation));
    }

    protected void stopMeasure() {
        if (!this.isMeasuring) {
            return;
        }
        this.isMeasuring = false;
        if (this.measureTimer != null) {
            this.measureTimer.cancel();
            this.measureTimer = null;
        }
        Log.d((String)TAG, (String)"\u505c\u6b62\u6d4b\u91cf");
        this.calculateFinalResult();
    }

    private void calculateFinalResult() {
        if (this.recentData.isEmpty()) {
            Log.w((String)TAG, (String)"\u6ca1\u6709\u6d4b\u91cf\u6570\u636e");
            return;
        }
        int totalHeartRate = 0;
        for (int hr : this.recentData) {
            totalHeartRate += hr;
        }
        int avgHeartRate = totalHeartRate / this.recentData.size();
        String measureId = "MEASURE_" + this.measureTime;
        String reportData = this.generateReportData(avgHeartRate);
        Log.d((String)TAG, (String)("\u6d4b\u91cf\u5b8c\u6210 - \u5e73\u5747\u5fc3\u7387: " + avgHeartRate + ", \u6d4b\u91cfID: " + measureId));
        this.uploadCSV();
        ResultListener listener = TaiyiManager.getInstance().getResultListener();
        if (listener != null) {
            this.mainHandler.post(() -> listener.onResult(String.valueOf(avgHeartRate), measureId, reportData));
        }
    }

    private String generateReportData(int avgHeartRate) {
        HashMap<String, Object> report = new HashMap<String, Object>();
        report.put("avgHeartRate", avgHeartRate);
        report.put("measureTime", this.measureTime);
        report.put("duration", System.currentTimeMillis() - this.measureTime);
        report.put("dataPoints", this.recentData.size());
        report.put("quality", avgHeartRate > 50 && avgHeartRate < 120 ? "\u826f\u597d" : "\u4e00\u822c");
        return ((Object)report).toString();
    }

    private void uploadCSV() {
        Log.d((String)TAG, (String)("\u4e0a\u4f20CSV\u6570\u636e\uff0c\u5927\u5c0f: " + this.csvData.length() + " \u5b57\u7b26"));
    }

    protected void onDestroy() {
        super.onDestroy();
        this.stopMeasure();
        Log.d((String)TAG, (String)"TYUsbDeviceActivity\u9500\u6bc1");
    }
}

