/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.zhimai.ui.activity;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.bluetooth.BluetoothGatt;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.blelib.bean.BleDeviceD;
import com.blelib.ble.BatteryEvent;
import com.blelib.ble.BleController;
import com.blelib.ble.BleEvent;
import com.blelib.ble.IDeviceInterface;
import com.google.android.material.tabs.TabLayout;
import com.jakewharton.rxbinding2.view.RxView;
import com.taiyi.typulse.R;
import com.taiyi.typulse.pulse.fastble.BleManager;
import com.taiyi.typulse.pulse.fastble.callback.BleGattCallback;
import com.taiyi.typulse.pulse.fastble.callback.BleScanCallback;
import com.taiyi.typulse.pulse.fastble.data.BleDevice;
import com.taiyi.typulse.pulse.fastble.exception.BleException;
import com.taiyi.typulse.pulse.fastble.scan.BleScanRuleConfig;
import com.taiyi.typulse.tyusbsdk.ResultListener;
import com.taiyi.typulse.tyusbsdk.USBDataTemp;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseResult;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpUtil;
import com.taiyi.typulse.tyusbsdk.pulse.net.TokenOverDueHttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.util.AppManager;
import com.taiyi.typulse.tyusbsdk.pulse.util.DialogTipUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.ProgressDialogUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.QTimeUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.ToastUtil;
import com.taiyi.typulse.zhimai.common.util.AppSizeCalUtil;
import com.taiyi.typulse.zhimai.common.util.DialogTipsUtil;
import com.taiyi.typulse.zhimai.ui.DeviceSAdapter;
import com.taiyi.typulse.zhimai.ui.activity.BleStateActivity;
import com.taiyi.typulse.zhimai.ui.activity.measure.BleMeasureFlowActivity;
import com.taiyi.typulse.zhimai.ui.activity.measure.Measure3Activity;
import com.taiyi.typulse.zhimai.ui.main.AlphaAndScalePageTransformer;
import com.taiyi.typulse.zhimai.ui.main.FragmentFactory;
import io.reactivex.functions.Consumer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONException;
import org.json.JSONObject;

public class MeasureMainActivity
extends BleStateActivity
implements ResultListener {
    private int retryType = 0;
    private static final int RETRY_LEFT = 201;
    private static final int RETRY_RIGHT = 202;
    private static final int RETRY_SAVE = 203;
    public static final int REQUEST_ENABLE_BT = 100;
    public static final int REQUEST_MEASURE_LEFT = 101;
    public static final int REQUEST_MEASURE_RIGHT = 102;
    public static final int REQUEST_TO_RESULT = 103;
    public static final int RESULT_MEASURE_FAIL = 203;
    private static final int REQUEST_PERMISSION_CODE = 106;
    public static final int CONNECT_MODE_USB = 1;
    public static final int CONNECT_MODE_BLE = 2;
    private int connect_mode;
    private ImageView ivBack;
    private TextView mTvScan;
    private TextView mTvOtg;
    private TabLayout mTl;
    private ViewPager mVp;
    private ConstraintLayout mClMain;
    private ConstraintLayout mClSecond;
    private ImageView mIvBg;
    private LinearLayout mLlBack;
    private ImageView mIvDevice;
    private ImageView nextBack;
    private TextView mTvLeft;
    private TextView mTvRight;
    private TextView mtvTypeLeft;
    private TextView mtvTypeRight;
    private LinearLayout mLlLeftHand;
    private LinearLayout mLlRightHand;
    private TextView mTvSubmit;
    private ImageView mIvLeftSelector;
    private ImageView mIvRightSelector;
    private boolean isLeftSelected = false;
    private boolean isRightSelected = false;
    private RecyclerView mRecyclerView;
    private TextView mTvConnect;
    private Dialog mDialog;
    private Dialog otgDialog;
    private DeviceSAdapter mDeviceSAdapter;
    private ScaleAnimation scaleAnimation;
    private List<String> mTabTitle;
    private ArrayList<String> mMissPermissions = new ArrayList();
    private int currentDeviceType = 3;
    private String leftMaiId;
    private String rightMaiId;

    @Override
    protected int initLayoutResId() {
        return R.layout.activity_measure_main;
    }

    @Override
    protected void init() {
        LogUtil.d("MeasureMainActivity", "init() started");
        this.initViews();
        this.initTab();
        this.getToken();
        this.initDeviceDialog();
        this.setDeviceStatusListener();
        this.resetToMeasure();
        LogUtil.d("MeasureMainActivity", "init() completed");
    }

    private void initViews() {
        LogUtil.d("MeasureMainActivity", "initViews() started");
        Configuration config = this.getResources().getConfiguration();
        LogUtil.d("MeasureMainActivity", "Screen size: " + config.screenLayout + ", orientation: " + config.orientation);
        LogUtil.d("MeasureMainActivity", "Screen width: " + this.getResources().getDisplayMetrics().widthPixels + ", height: " + this.getResources().getDisplayMetrics().heightPixels);
        LogUtil.d("MeasureMainActivity", "Density: " + this.getResources().getDisplayMetrics().density);
        this.ivBack = (ImageView)this.findViewById(R.id.iv_back);
        this.mTl = (TabLayout)this.findViewById(R.id.tl);
        this.mVp = (ViewPager)this.findViewById(R.id.vp);
        this.mIvDevice = (ImageView)this.findViewById(R.id.iv_device);
        this.mTvOtg = (TextView)this.findViewById(R.id.tv_otg);
        this.mTvScan = (TextView)this.findViewById(R.id.tv_scan);
        this.mClMain = (ConstraintLayout)this.findViewById(R.id.cl_main);
        this.mClSecond = (ConstraintLayout)this.findViewById(R.id.cl_second);
        this.mIvBg = (ImageView)this.findViewById(R.id.iv_bg);
        this.mTvSubmit = (TextView)this.findViewById(R.id.tv_submit);
        this.mLlBack = (LinearLayout)this.findViewById(R.id.ll_back);
        this.nextBack = (ImageView)this.findViewById(R.id.n_back);
        this.mTvLeft = (TextView)this.findViewById(R.id.tv_left);
        this.mtvTypeLeft = (TextView)this.findViewById(R.id.tv_type_left);
        this.mTvRight = (TextView)this.findViewById(R.id.tv_right);
        this.mtvTypeRight = (TextView)this.findViewById(R.id.tv_type_right);
        this.mLlLeftHand = (LinearLayout)this.findViewById(R.id.ll_left_hand);
        this.mLlRightHand = (LinearLayout)this.findViewById(R.id.ll_right_hand);
        this.mIvLeftSelector = (ImageView)this.findViewById(R.id.iv_left_selector);
        this.mIvRightSelector = (ImageView)this.findViewById(R.id.iv_right_selector);
        LogUtil.d("MeasureMainActivity", "ViewPager initialized: " + (this.mVp != null));
        LogUtil.d("MeasureMainActivity", "TabLayout initialized: " + (this.mTl != null));
        LogUtil.d("MeasureMainActivity", "cl_main initialized: " + (this.mClMain != null));
        LogUtil.d("MeasureMainActivity", "cl_second initialized: " + (this.mClSecond != null));
        LogUtil.d("MeasureMainActivity", "tv_submit initialized: " + (this.mTvSubmit != null));
        if (this.mVp != null) {
            LogUtil.d("MeasureMainActivity", "ViewPager found, adding layout listener");
            this.mVp.post(new Runnable(){

                @Override
                public void run() {
                    LogUtil.d("MeasureMainActivity", "ViewPager layout - Width: " + MeasureMainActivity.this.mVp.getWidth() + ", Height: " + MeasureMainActivity.this.mVp.getHeight());
                    LogUtil.d("MeasureMainActivity", "ViewPager layout params: " + MeasureMainActivity.this.mVp.getLayoutParams().toString());
                    LogUtil.d("MeasureMainActivity", "ViewPager visibility: " + MeasureMainActivity.this.mVp.getVisibility());
                    LogUtil.d("MeasureMainActivity", "ViewPager left: " + MeasureMainActivity.this.mVp.getLeft() + ", top: " + MeasureMainActivity.this.mVp.getTop() + ", right: " + MeasureMainActivity.this.mVp.getRight() + ", bottom: " + MeasureMainActivity.this.mVp.getBottom());
                }
            });
        } else {
            LogUtil.e("MeasureMainActivity", "ViewPager is null!");
        }
        this.mIvLeftSelector.setOnClickListener(v -> this.toggleLeftSelector());
        this.mIvRightSelector.setOnClickListener(v -> this.toggleRightSelector());
        this.mTvSubmit.setOnClickListener(v -> this.submit());
        this.mTvScan.setOnClickListener(v -> this.doConnect());
        this.mLlBack.setOnClickListener(v -> {
            this.clearDeviceSAdapter();
            this.finish();
        });
        this.ivBack.setColorFilter(ContextCompat.getColor((Context)this, (int)R.color.colorPrimary));
        this.nextBack.setColorFilter(ContextCompat.getColor((Context)this, (int)R.color.colorPrimary));
        this.ivBack.setOnClickListener(v -> this.finish());
        if (BleController.getInstance().isConnected()) {
            this.doConnect();
        }
        if (BleController.getInstance().getConnectedDeviceType() == 7) {
            this.mIvDevice.setImageResource(R.drawable.device_7);
            this.currentDeviceType = 7;
        } else if (BleController.getInstance().getConnectedDeviceType() == 3) {
            this.mIvDevice.setImageResource(R.drawable.device_3);
            this.currentDeviceType = 3;
        }
    }

    private void initTab() {
        this.mTabTitle = new ArrayList<String>();
        this.mTabTitle.add(this.getString(R.string.device_ble));
        this.scaleAnimation = new ScaleAnimation(1.0f, 1.05f, 1.0f, 1.05f, 1, 0.5f, 1, 0.5f);
        this.scaleAnimation.setDuration(200L);
        this.scaleAnimation.setFillAfter(true);
        this.connect_mode = 2;
        this.mTl.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                MeasureMainActivity.this.connect_mode = 2;
                MeasureMainActivity.this.mTvScan.setText(R.string.pulse_connect2);
                TabLayout.TabView tabView = tab.view;
                try {
                    Field mTextViewField = tabView.getClass().getDeclaredField("textView");
                    mTextViewField.setAccessible(true);
                    TextView textView = (TextView)mTextViewField.get(tabView);
                    textView.startAnimation((Animation)MeasureMainActivity.this.scaleAnimation);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }

            public void onTabUnselected(TabLayout.Tab tab) {
                TabLayout.TabView tabView = tab.view;
                try {
                    Field mTextViewField = tabView.getClass().getDeclaredField("textView");
                    mTextViewField.setAccessible(true);
                    TextView textView = (TextView)mTextViewField.get(tabView);
                    textView.clearAnimation();
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
        this.mTl.setupWithViewPager(this.mVp);
        this.mVp.setAdapter((PagerAdapter)new FragmentPagerAdapter(this.getSupportFragmentManager()){

            public Fragment getItem(int i) {
                return FragmentFactory.create(i);
            }

            public int getCount() {
                return MeasureMainActivity.this.mTabTitle.size();
            }

            @Nullable
            public CharSequence getPageTitle(int position) {
                return (CharSequence)MeasureMainActivity.this.mTabTitle.get(position);
            }
        });
        this.mVp.setPageMargin((int)((double)AppSizeCalUtil.getWidth((Context)this) * 0.03));
        this.mVp.setOffscreenPageLimit(3);
        this.mVp.setPageTransformer(true, (ViewPager.PageTransformer)new AlphaAndScalePageTransformer());
    }

    private void getToken() {
        HttpUtil.getInstance().getRequestQueue((Context)this).check(new HttpImpl<String>(){

            @Override
            public void showError(String error) {
                DialogTipUtil.showSelectDialog((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.dialog_tip_tip), MeasureMainActivity.this.getString(R.string.measure_skip_tip_1), R.string.measure_skip, R.string.dialog_tip_retry, new DialogTipUtil.OptionClickCallback_I(){

                    @Override
                    public void leftClick() {
                        TaiyiManager.getInstance().clearMeasure();
                        if (TaiyiManager.getInstance().getSkipInterface() != null) {
                            TaiyiManager.getInstance().getSkipInterface().onSkip();
                        }
                        MeasureMainActivity.this.finish();
                    }

                    @Override
                    public void rightClick() {
                        MeasureMainActivity.this.getToken();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                HttpUtil.AuthorizationValue = response;
                switch (MeasureMainActivity.this.retryType) {
                    case 201: {
                        MeasureMainActivity.this.getLeftUUID();
                        break;
                    }
                    case 202: {
                        MeasureMainActivity.this.getRightUUID();
                        break;
                    }
                    case 203: {
                        MeasureMainActivity.this.saveMai();
                        break;
                    }
                    default: {
                        BleController.getInstance().init(MeasureMainActivity.this.getApplication());
                    }
                }
            }
        });
    }

    private void initDeviceDialog() {
        this.mDialog = new Dialog((Context)this, R.style.simpleDialogStyle);
        View view = LayoutInflater.from((Context)this).inflate(R.layout.layout_device_choose, null);
        ImageView iv_cancel = (ImageView)view.findViewById(R.id.iv_cancel);
        iv_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MeasureMainActivity.this.connect_mode == 2) {
                    BleController.getInstance().cancelScan();
                }
                MeasureMainActivity.this.clearDeviceSAdapter();
                MeasureMainActivity.this.mDialog.dismiss();
            }
        });
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.recycler);
        this.mTvConnect = (TextView)view.findViewById(R.id.tv_connect);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mDialog.setContentView(view);
        this.mDialog.setCancelable(false);
    }

    private void setDeviceStatusListener() {
        BleController.getInstance().setIBLEInterface(new IDeviceInterface(){

            @Override
            public void onStatus(int status, int battery) {
                if (BleController.getInstance().getYjversion() == 0) {
                    BleController.getInstance().getVersion();
                }
                EventBus.getDefault().post((Object)new BatteryEvent(battery));
            }

            @Override
            public void onVersion(int hardware, int firmware, int data, int channel) {
                LogUtil.w("qxj MainActivity", "\u786c\u4ef6\u7248\u672c:" + hardware + ",\u56fa\u4ef6\u7248\u672c:" + firmware + ",\u6570\u636e\u7248\u672c:" + data);
                BleController.getInstance().getStatus();
                if (MeasureMainActivity.this.mIvDevice != null) {
                    if (hardware > 7000) {
                        MeasureMainActivity.this.mIvDevice.setImageResource(R.drawable.device_7);
                        MeasureMainActivity.this.currentDeviceType = 7;
                        BleController.getInstance().setConnectedDeviceType(7);
                    } else {
                        MeasureMainActivity.this.currentDeviceType = 3;
                        BleController.getInstance().setConnectedDeviceType(3);
                        MeasureMainActivity.this.mIvDevice.setImageResource(R.drawable.device_3);
                    }
                    MeasureMainActivity.this.mIvDevice.setVisibility(0);
                } else if (hardware > 7000) {
                    MeasureMainActivity.this.currentDeviceType = 7;
                    BleController.getInstance().setConnectedDeviceType(7);
                } else {
                    MeasureMainActivity.this.currentDeviceType = 3;
                    BleController.getInstance().setConnectedDeviceType(3);
                }
            }

            @Override
            public void onLowPowerNotify(int battery) {
                String msg = MeasureMainActivity.this.getString(R.string.device_low_power_1);
                if (AppManager.getAppManager().currentActivity() instanceof Measure3Activity) {
                    LogUtil.w("MainActivity", "Measure3Activity need not tip");
                } else {
                    DialogTipUtil.showIKnow((Context)AppManager.getAppManager().currentActivity(), msg);
                    LogUtil.w("MainActivity", "tip power:" + msg);
                }
            }

            @Override
            public void onInitSensorFailed() {
                if (AppManager.getAppManager().currentActivity() instanceof MeasureMainActivity) {
                    DialogTipUtil.showIKnow((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.device_fault));
                } else {
                    EventBus.getDefault().post((Object)new BleEvent(2));
                }
            }
        });
    }

    private void doConnect() {
        this.connect_mode = 2;
        if (!BleController.getInstance().isConnected()) {
            this.setScanRule();
        } else {
            this.mClMain.setVisibility(8);
            this.mClSecond.setVisibility(0);
            this.mIvBg.setVisibility(8);
        }
    }

    private void setScanRule() {
        BleScanRuleConfig scanRuleConfig = new BleScanRuleConfig.Builder().setServiceUuids(new UUID[]{UUID.fromString("0000FFF0-0000-1000-8000-00805F9B34FB")}).setDeviceName(true, "TY").setScanTimeOut(Integer.MAX_VALUE).build();
        BleManager.getInstance().initScanRule(scanRuleConfig);
        this.checkAndRequestPermissions();
    }

    private void checkAndRequestPermissions() {
        if (Build.VERSION.SDK_INT < 23) {
            this.scan();
        } else if (Build.VERSION.SDK_INT < 31) {
            if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
                this.scan();
            } else {
                this.mMissPermissions.add("android.permission.ACCESS_FINE_LOCATION");
                this.popupPermissionTip(this.mMissPermissions, R.string.permission_ble, 106);
            }
        } else if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 && ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.BLUETOOTH_SCAN") == 0) {
            this.scan();
        } else {
            if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
                this.mMissPermissions.add("android.permission.ACCESS_FINE_LOCATION");
            }
            if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.BLUETOOTH_SCAN") != 0) {
                this.mMissPermissions.add("android.permission.BLUETOOTH_SCAN");
                this.mMissPermissions.add("android.permission.BLUETOOTH_CONNECT");
                this.mMissPermissions.add("android.permission.BLUETOOTH_ADVERTISE");
            }
            LogUtil.w(this.TAG, "mMissPermissions:" + this.mMissPermissions);
            this.popupPermissionTip(this.mMissPermissions, R.string.permission_ble_1, 106);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (grantResults.length != 0 && requestCode == 106) {
            for (int i = grantResults.length - 1; i >= 0; --i) {
                if (grantResults[i] != 0) continue;
                this.mMissPermissions.remove(permissions[i]);
            }
            if (!this.mMissPermissions.isEmpty()) {
                if (this.mMissPermissions.contains("android.permission.ACCESS_FINE_LOCATION")) {
                    Toast.makeText((Context)this, (CharSequence)this.getString(R.string.ble_permission_disabled), (int)0).show();
                } else if (this.mMissPermissions.contains("android.permission.BLUETOOTH_SCAN")) {
                    Toast.makeText((Context)this, (CharSequence)this.getString(R.string.permission_ble_1), (int)0).show();
                }
                this.checkAndRequestPermissions();
            } else {
                this.scan();
            }
        }
    }

    private void scan() {
        if (this.mDeviceSAdapter == null) {
            this.mDeviceSAdapter = new DeviceSAdapter();
        }
        if (BleManager.getInstance().isBlueEnable()) {
            BleManager.getInstance().scan(new BleScanCallback(){

                @Override
                public void onScanStarted(boolean success) {
                    MeasureMainActivity.this.clearDeviceSAdapter();
                }

                @Override
                public void onLeScan(BleDevice bleDevice) {
                    super.onLeScan(bleDevice);
                }

                @Override
                public void onScanning(BleDevice bleDevice) {
                    BleDeviceD s = new BleDeviceD();
                    s.mDevice = bleDevice;
                    MeasureMainActivity.this.mDeviceSAdapter.addData(s);
                }

                @Override
                public void onScanFinished(List<BleDevice> scanResultList) {
                }
            });
            this.setDialogData(this.mDeviceSAdapter, -1, new DialogTipsUtil.DeviceSelectCallback(){

                @Override
                public void onSuccess(BleDevice bleDevice) {
                    BleManager.getInstance().cancelScan();
                    MeasureMainActivity.this.connectDevice(bleDevice);
                }
            });
        } else {
            this.enableBLE();
        }
    }

    private void enableBLE() {
        Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.BLUETOOTH_CONNECT") != 0) {
            return;
        }
        this.startActivityForResult(enableBtIntent, 100);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100) {
            if (resultCode == -1) {
                this.scan();
            } else {
                Toast.makeText((Context)this, (int)R.string.ble_unable, (int)0).show();
            }
        } else if (requestCode == 101) {
            if (resultCode == -1) {
                if (this.connect_mode == 1) {
                    this.leftMaiId = USBDataTemp.getInstance().measure_id;
                } else if (this.connect_mode == 2) {
                    this.leftMaiId = BleController.getInstance().getUuid();
                }
                this.mtvTypeLeft.setText(R.string.measure_succeed_tip);
                this.mtvTypeLeft.setBackground(ContextCompat.getDrawable((Context)this, (int)R.drawable.bg_green_border_3dp));
            } else if (resultCode == 203) {
                this.mtvTypeLeft.setText(R.string.measure_failed_tip);
                this.mtvTypeLeft.setBackground(ContextCompat.getDrawable((Context)this, (int)R.drawable.bg_red_border_3dp));
            }
            this.updateMeasureStatus();
        } else if (requestCode == 102) {
            if (resultCode == -1) {
                if (this.connect_mode == 1) {
                    this.rightMaiId = USBDataTemp.getInstance().measure_id;
                } else if (this.connect_mode == 2) {
                    this.rightMaiId = BleController.getInstance().getUuid();
                }
                this.mtvTypeRight.setText(R.string.measure_succeed_tip);
                this.mtvTypeRight.setBackground(ContextCompat.getDrawable((Context)this, (int)R.drawable.bg_green_border_3dp));
            } else if (resultCode == 203) {
                this.mtvTypeRight.setText(R.string.measure_failed_tip);
                this.mtvTypeRight.setBackground(ContextCompat.getDrawable((Context)this, (int)R.drawable.bg_red_border_3dp));
            }
            this.updateMeasureStatus();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void connectDevice(BleDevice bleDevice) {
        BleManager.getInstance().connect(bleDevice, new BleGattCallback(){

            @Override
            public void onStartConnect() {
                ProgressDialogUtil.show((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.ble_connecting));
                BleController.getInstance().cancelScan();
            }

            @Override
            public void onConnectFail(BleDevice bleDevice, BleException exception) {
                ProgressDialogUtil.close();
                ToastUtil.show((Context)MeasureMainActivity.this, R.string.ble_connect_failed);
                BleController.getInstance().setConnected(false);
                MeasureMainActivity.this.clearDeviceSAdapter();
                MeasureMainActivity.this.scan();
            }

            @Override
            public void onConnectSuccess(BleDevice bleDevice, BluetoothGatt gatt, int status) {
                ProgressDialogUtil.close();
                MeasureMainActivity.this.mClMain.setVisibility(8);
                MeasureMainActivity.this.mClSecond.setVisibility(0);
                MeasureMainActivity.this.mIvBg.setVisibility(8);
                BleController.getInstance().setBleDevice(bleDevice);
                BleController.getInstance().setConnected(true);
                MeasureMainActivity.this.getDeviceState();
            }

            @Override
            public void onDisConnected(boolean isActiveDisConnected, BleDevice bleDevice, BluetoothGatt gatt, int status) {
                BleController.getInstance().recycle();
                ProgressDialogUtil.close();
                BleController.getInstance().setConnectedDeviceType(-1);
                BleController.getInstance().setConnected(false);
                MeasureMainActivity.this.clearDeviceSAdapter();
                MeasureMainActivity.this.resetUI();
                if (AppManager.getAppManager().currentActivity() != null && AppManager.getAppManager().currentActivity() instanceof MeasureMainActivity && !MeasureMainActivity.this.isFinishing()) {
                    DialogTipUtil.showIKnow((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.device_disconnect));
                } else {
                    EventBus.getDefault().post((Object)new BleEvent(1));
                }
            }
        });
    }

    private void getDeviceState() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                BleController.getInstance().getStatus();
            }
        }, 400L);
    }

    private void setDialogData(final DeviceSAdapter adapter, int selectPosition, final DialogTipsUtil.DeviceSelectCallback callbackI) {
        if (adapter == null) {
            return;
        }
        adapter.setRecycler(this.mRecyclerView);
        adapter.setPosition(selectPosition);
        this.mTvConnect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int posClick = adapter.getPosition();
                if (posClick == -1) {
                    Toast.makeText((Context)MeasureMainActivity.this, (CharSequence)MeasureMainActivity.this.getString(R.string.device_select_one), (int)0).show();
                    return;
                }
                if (adapter.getData().isEmpty()) {
                    Toast.makeText((Context)MeasureMainActivity.this, (CharSequence)MeasureMainActivity.this.getString(R.string.device_scan_null), (int)0).show();
                    return;
                }
                callbackI.onSuccess(adapter.getData().get((int)posClick).mDevice);
                MeasureMainActivity.this.mDialog.dismiss();
                if (MeasureMainActivity.this.connect_mode == 1) {
                    MeasureMainActivity.this.mClMain.setVisibility(8);
                    MeasureMainActivity.this.mIvBg.setVisibility(8);
                    MeasureMainActivity.this.mClSecond.setVisibility(0);
                }
            }
        });
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
        this.mDialog.show();
    }

    private void clearDeviceSAdapter() {
        if (this.mDeviceSAdapter != null && this.mDeviceSAdapter.getData() != null) {
            this.mDeviceSAdapter.getData().clear();
            this.mDeviceSAdapter.setPosition(-1);
            this.mDeviceSAdapter.notifyDataSetChanged();
        }
    }

    private void resetUI() {
        if (this.mIvDevice != null) {
            this.mIvDevice.setImageResource(0);
        }
        USBDataTemp.getInstance().clear();
        if (this.mClMain != null) {
            this.mClMain.setVisibility(0);
        }
        if (this.mClSecond != null) {
            this.mClSecond.setVisibility(8);
        }
        if (this.mIvBg != null) {
            this.mIvBg.setVisibility(0);
        }
        this.resetToMeasure();
    }

    private void resetToMeasure() {
        this.leftMaiId = null;
        this.rightMaiId = null;
        this.mtvTypeLeft.setText((CharSequence)"");
        this.mtvTypeLeft.setBackground(null);
        this.mtvTypeRight.setText((CharSequence)"");
        this.mtvTypeRight.setBackground(null);
        this.updateMeasureStatus();
    }

    @SuppressLint(value={"CheckResult"})
    private void updateMeasureStatus() {
        if (!TextUtils.isEmpty((CharSequence)this.leftMaiId) && !TextUtils.isEmpty((CharSequence)this.rightMaiId)) {
            this.mTvLeft.setEnabled(false);
            this.mTvRight.setEnabled(false);
            this.leftDark();
            this.rightDark();
            this.mTvSubmit.setText(R.string.full_report);
            this.mTvSubmit.setEnabled(true);
        } else if (!TextUtils.isEmpty((CharSequence)this.leftMaiId)) {
            this.mTvLeft.setEnabled(true);
            this.mTvRight.setEnabled(true);
            this.leftDark();
            this.rightLight();
            RxView.clicks((View)this.mTvLeft).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    Toast.makeText((Context)MeasureMainActivity.this, (CharSequence)MeasureMainActivity.this.getString(R.string.measure_right_tip_1), (int)0).show();
                }
            });
            RxView.clicks((View)this.mLlLeftHand).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    Toast.makeText((Context)MeasureMainActivity.this, (CharSequence)MeasureMainActivity.this.getString(R.string.measure_right_tip_1), (int)0).show();
                }
            });
            RxView.clicks((View)this.mTvRight).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    MeasureMainActivity.this.getRightUUID();
                }
            });
            RxView.clicks((View)this.mLlRightHand).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    MeasureMainActivity.this.getRightUUID();
                }
            });
            this.mTvSubmit.setText(R.string.full_report);
            this.mTvSubmit.setEnabled(true);
        } else if (!TextUtils.isEmpty((CharSequence)this.rightMaiId)) {
            LogUtil.w("MainActivityB updateMeasureStatus DOUBLE", "left  null");
            this.mTvLeft.setEnabled(true);
            this.mTvRight.setEnabled(true);
            this.leftLight();
            this.rightDark();
            RxView.clicks((View)this.mTvLeft).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    MeasureMainActivity.this.getLeftUUID();
                }
            });
            RxView.clicks((View)this.mLlLeftHand).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    MeasureMainActivity.this.getLeftUUID();
                }
            });
            RxView.clicks((View)this.mTvRight).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    Toast.makeText((Context)MeasureMainActivity.this, (CharSequence)MeasureMainActivity.this.getString(R.string.measure_left_tip_1), (int)0).show();
                }
            });
            RxView.clicks((View)this.mLlRightHand).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    Toast.makeText((Context)MeasureMainActivity.this, (CharSequence)MeasureMainActivity.this.getString(R.string.measure_left_tip_1), (int)0).show();
                }
            });
            this.mTvSubmit.setText(R.string.full_report);
            this.mTvSubmit.setEnabled(true);
        } else {
            LogUtil.w("MainActivityB updateMeasureStatus DOUBLE", "left  null");
            this.mTvLeft.setEnabled(true);
            this.mTvRight.setEnabled(true);
            this.leftLight();
            this.rightLight();
            RxView.clicks((View)this.mTvLeft).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    MeasureMainActivity.this.getLeftUUID();
                }
            });
            RxView.clicks((View)this.mLlLeftHand).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    MeasureMainActivity.this.getLeftUUID();
                }
            });
            RxView.clicks((View)this.mTvRight).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    MeasureMainActivity.this.getRightUUID();
                }
            });
            RxView.clicks((View)this.mLlRightHand).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    MeasureMainActivity.this.getRightUUID();
                }
            });
            this.mTvSubmit.setEnabled(false);
            this.mTvSubmit.setText(R.string.beginTypluse);
        }
    }

    private void leftLight() {
    }

    private void leftDark() {
    }

    private void rightLight() {
    }

    private void rightDark() {
    }

    private void getLeftUUID() {
        HttpUtil.getInstance().getUUID(new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
                MeasureMainActivity.this.retryType = 201;
                MeasureMainActivity.this.getToken();
            }

            @Override
            public void showError(String error) {
                MeasureMainActivity.this.retryType = 201;
                DialogTipUtil.showSelectDialog((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.dialog_tip_tip), MeasureMainActivity.this.getString(R.string.measure_skip_tip_1), R.string.measure_skip, R.string.dialog_tip_retry, new DialogTipUtil.OptionClickCallback_I(){

                    @Override
                    public void leftClick() {
                        TaiyiManager.getInstance().clearMeasure();
                        if (TaiyiManager.getInstance().getSkipInterface() != null) {
                            TaiyiManager.getInstance().getSkipInterface().onSkip();
                        }
                        MeasureMainActivity.this.finish();
                    }

                    @Override
                    public void rightClick() {
                        MeasureMainActivity.this.getLeftUUID();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                MeasureMainActivity.this.retryType = 0;
                BleController.getInstance().setUuid(response);
                BleController.getInstance().setHand(0);
                Intent intent = new Intent((Context)MeasureMainActivity.this, BleMeasureFlowActivity.class);
                intent.putExtra("measureId", response);
                intent.putExtra("hand", 0);
                MeasureMainActivity.this.startActivityForResult(intent, 101);
            }
        });
    }

    private void getRightUUID() {
        HttpUtil.getInstance().getUUID(new TokenOverDueHttpImpl<String>(){

            @Override
            public void showResponse(String response) {
                Log.d((String)"qxj getRightUUID req", (String)response);
                MeasureMainActivity.this.retryType = 0;
                BleController.getInstance().setUuid(response);
                BleController.getInstance().setHand(1);
                Intent intent = new Intent((Context)MeasureMainActivity.this, BleMeasureFlowActivity.class);
                intent.putExtra("measureId", response);
                intent.putExtra("hand", 1);
                MeasureMainActivity.this.startActivityForResult(intent, 102);
            }

            @Override
            public void overdue() {
                MeasureMainActivity.this.retryType = 202;
                MeasureMainActivity.this.getToken();
            }

            @Override
            public void showError(String error) {
                MeasureMainActivity.this.retryType = 202;
                DialogTipUtil.showSelectDialog((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.dialog_tip_tip), MeasureMainActivity.this.getString(R.string.measure_skip_tip_1), R.string.measure_skip, R.string.dialog_tip_retry, new DialogTipUtil.OptionClickCallback_I(){

                    @Override
                    public void leftClick() {
                        TaiyiManager.getInstance().clearMeasure();
                        if (TaiyiManager.getInstance().getSkipInterface() != null) {
                            TaiyiManager.getInstance().getSkipInterface().onSkip();
                        }
                        MeasureMainActivity.this.finish();
                    }

                    @Override
                    public void rightClick() {
                        MeasureMainActivity.this.getRightUUID();
                    }
                });
            }
        });
    }

    private void submit() {
        if (this.leftMaiId == null || this.rightMaiId == null) {
            DialogTipUtil.showSingleHandDialog((Context)this, new DialogTipUtil.OptionClickCallback_I(){

                @Override
                public void leftClick() {
                    MeasureMainActivity.this.saveMai();
                }

                @Override
                public void rightClick() {
                }
            });
        } else {
            this.saveMai();
        }
    }

    private void saveMai() {
        HttpUtil.getInstance().saveCombined(this.leftMaiId, this.rightMaiId, new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
                MeasureMainActivity.this.retryType = 203;
                MeasureMainActivity.this.getToken();
            }

            @Override
            public void showError(String error) {
                MeasureMainActivity.this.retryType = 203;
                DialogTipUtil.showSelectDialog((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.dialog_tip_tip), MeasureMainActivity.this.getString(R.string.measure_skip_tip_1), R.string.measure_skip, R.string.dialog_tip_retry, new DialogTipUtil.OptionClickCallback_I(){

                    @Override
                    public void leftClick() {
                        TaiyiManager.getInstance().clearMeasure();
                        if (TaiyiManager.getInstance().getSkipInterface() != null) {
                            TaiyiManager.getInstance().getSkipInterface().onSkip();
                        }
                        MeasureMainActivity.this.finish();
                    }

                    @Override
                    public void rightClick() {
                        MeasureMainActivity.this.saveMai();
                    }
                });
            }

            @Override
            public void showResponse(String measureId) {
                MeasureMainActivity.this.retryType = 0;
                MeasureMainActivity.this.getCombinedReportDesc(measureId);
            }
        });
    }

    public void getCombinedReportDesc(final String combiledId) {
        HttpUtil.getInstance().getCombinedDesc(combiledId, new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
                DialogTipUtil.showSelectDialog((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.dialog_tip_tip), MeasureMainActivity.this.getString(R.string.measure_skip_tip_1), R.string.measure_skip, R.string.dialog_tip_retry, new DialogTipUtil.OptionClickCallback_I(){

                    @Override
                    public void leftClick() {
                        TaiyiManager.getInstance().clearMeasure();
                        if (TaiyiManager.getInstance().getSkipInterface() != null) {
                            TaiyiManager.getInstance().getSkipInterface().onSkip();
                        }
                        MeasureMainActivity.this.finish();
                    }

                    @Override
                    public void rightClick() {
                        MeasureMainActivity.this.getCombinedReportDesc(combiledId);
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                Log.d((String)"qxj showResponse", (String)response);
                if (response == null || response.trim().isEmpty()) {
                    LogUtil.e("MeasureMainActivity", "Empty or null response received in getCombinedReportDesc");
                    DialogTipUtil.showIKnow((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.measure_failed), new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                        }
                    });
                    return;
                }
                try {
                    String pulseUrl = "https://hybrid.reborn-tech.com/";
                    pulseUrl = pulseUrl + "report.html#/?mid=" + combiledId + "&access_session=" + HttpUtil.AuthorizationValue + "&appId=" + TaiyiManager.getInstance().getAppId();
                    Log.d((String)"qxj pulseUrl", (String)pulseUrl);
                    String handStyle = "";
                    if (MeasureMainActivity.this.leftMaiId != null && MeasureMainActivity.this.rightMaiId != null) {
                        handStyle = "DOUBLE";
                    } else if (MeasureMainActivity.this.leftMaiId != null) {
                        handStyle = "LEFT";
                    } else if (MeasureMainActivity.this.rightMaiId != null) {
                        handStyle = "RIGHT";
                    }
                    String pr = PulseResult.create(combiledId, pulseUrl, handStyle, QTimeUtil.toDatetimeStr(), response).toString();
                    LogUtil.e("qxj PulseResult", pr);
                    TaiyiManager.getInstance().setPulseResult(pr);
                    MeasureMainActivity.this.getCombinedReportDescNext(combiledId);
                }
                catch (Exception e) {
                    LogUtil.e("qxj MeasureMainActivity", "Error processing response: " + e.getMessage());
                    DialogTipUtil.showIKnow((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.measure_failed), new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                        }
                    });
                }
            }
        });
    }

    @Override
    protected void onDestroy() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
        if (this.otgDialog != null) {
            this.otgDialog.dismiss();
        }
        super.onDestroy();
        if (BleController.getInstance().isConnected()) {
            BleController.getInstance().disconnect();
        }
    }

    @Override
    public void onResult(String pr, String cmdType, String measureId, String reportData) {
    }

    public void getCombinedReportDescNext(final String combiledId) {
        HttpUtil.getInstance().getPulseTotalDesc(combiledId, new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
                DialogTipUtil.showSelectDialog((Context)MeasureMainActivity.this, MeasureMainActivity.this.getString(R.string.dialog_tip_tip), MeasureMainActivity.this.getString(R.string.measure_skip_tip_1), R.string.measure_skip, R.string.dialog_tip_retry, new DialogTipUtil.OptionClickCallback_I(){

                    @Override
                    public void leftClick() {
                        TaiyiManager.getInstance().clearMeasure();
                        if (TaiyiManager.getInstance().getSkipInterface() != null) {
                            TaiyiManager.getInstance().getSkipInterface().onSkip();
                        }
                        MeasureMainActivity.this.finish();
                    }

                    @Override
                    public void rightClick() {
                        MeasureMainActivity.this.getCombinedReportDesc(combiledId);
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                Log.d((String)"qxj showResponse ", (String)response);
                if (response == null) {
                    LogUtil.e(MeasureMainActivity.this.TAG, "Response is null");
                    DialogTipUtil.showIKnow((Context)MeasureMainActivity.this, "\u670d\u52a1\u5668\u54cd\u5e94\u4e3a\u7a7a", new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            MeasureMainActivity.this.finish();
                        }
                    });
                    return;
                }
                if (response.trim().isEmpty()) {
                    LogUtil.e(MeasureMainActivity.this.TAG, "Response is empty");
                    DialogTipUtil.showIKnow((Context)MeasureMainActivity.this, "\u670d\u52a1\u5668\u54cd\u5e94\u4e3a\u7a7a\u5b57\u7b26\u4e32", new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            MeasureMainActivity.this.finish();
                        }
                    });
                    return;
                }
                try {
                    String cleanResponse = response.trim();
                    if (cleanResponse.startsWith("\ufeff")) {
                        cleanResponse = cleanResponse.substring(1);
                    }
                    JSONObject jsonObject = new JSONObject(cleanResponse);
                    LogUtil.d(MeasureMainActivity.this.TAG, "JSON parsed successfully, adding URLs");
                    String jsonString = jsonObject.toString();
                    String pulseResult = TaiyiManager.getInstance().getPulseResult();
                    LogUtil.d(MeasureMainActivity.this.TAG, "\u51c6\u5907\u8c03\u7528TaiyiManager.onResult - measureId: " + combiledId);
                    LogUtil.d(MeasureMainActivity.this.TAG, "pulseResult: " + (pulseResult != null ? "\u6709\u6570\u636e" : "null"));
                    LogUtil.d(MeasureMainActivity.this.TAG, "jsonString\u957f\u5ea6: " + (jsonString != null ? jsonString.length() : 0));
                    TaiyiManager.getInstance().onResult(pulseResult, "pulseResult", combiledId, jsonString);
                    LogUtil.d(MeasureMainActivity.this.TAG, "\u5df2\u8c03\u7528TaiyiManager.onResult");
                    if (TextUtils.isEmpty((CharSequence)pulseResult)) {
                        LogUtil.w(MeasureMainActivity.this.TAG, "pulse result null");
                        ToastUtil.show((Context)MeasureMainActivity.this, "\u6d4b\u91cf\u7684\u8109\u640f\u6570\u636e\u4e3anull");
                    } else {
                        LogUtil.w(MeasureMainActivity.this.TAG, TaiyiManager.getInstance().getPulseResult());
                    }
                    AppManager.getAppManager().finishAllActivity();
                }
                catch (JSONException e) {
                    String errorDetail = "JSON\u89e3\u6790\u9519\u8bef: " + e.getMessage();
                    errorDetail = response.length() > 100 ? errorDetail + "\n\u54cd\u5e94\u524d100\u5b57\u7b26: " + response.substring(0, 100) : errorDetail + "\n\u5b8c\u6574\u54cd\u5e94: " + response;
                    DialogTipUtil.showIKnow((Context)MeasureMainActivity.this, errorDetail, new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            MeasureMainActivity.this.finish();
                        }
                    });
                }
                catch (Exception e) {
                    LogUtil.e(MeasureMainActivity.this.TAG, "General error: " + e.getMessage());
                    Toast.makeText((Context)MeasureMainActivity.this, (CharSequence)e.getMessage(), (int)1).show();
                    DialogTipUtil.showIKnow((Context)MeasureMainActivity.this, "\u5904\u7406\u54cd\u5e94\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            MeasureMainActivity.this.finish();
                        }
                    });
                }
            }
        });
    }

    private void toggleLeftSelector() {
        this.isLeftSelected = !this.isLeftSelected;
        this.updateLeftSelectorUI();
    }

    private void toggleRightSelector() {
        this.isRightSelected = !this.isRightSelected;
        this.updateRightSelectorUI();
    }

    private void updateLeftSelectorUI() {
        if (this.isLeftSelected) {
            this.mIvLeftSelector.setImageResource(R.mipmap.radio_choose_icon16);
        } else {
            this.mIvLeftSelector.setImageResource(R.mipmap.radio_default_icon16);
        }
    }

    private void updateRightSelectorUI() {
        if (this.isRightSelected) {
            this.mIvRightSelector.setImageResource(R.mipmap.radio_choose_icon16);
        } else {
            this.mIvRightSelector.setImageResource(R.mipmap.radio_default_icon16);
        }
    }
}

