/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.zhimai.ui.activity.measure;

import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.os.StrictMode;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.blelib.bean.SanBuJiuHou;
import com.blelib.ble.BleController;
import com.blelib.ble.IMeasureListenerHeatMap;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.LogUtils;
import com.taiyi.typulse.tyusbsdk.OssFileUtil;
import com.taiyi.typulse.tyusbsdk.TYUsbDeviceActivity;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseCharacter;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseFigure;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseParam;
import com.taiyi.typulse.tyusbsdk.pulse.bean.Pulsebean;
import com.taiyi.typulse.tyusbsdk.pulse.bean.TotalPulse;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpUtil;
import com.taiyi.typulse.tyusbsdk.pulse.net.TokenOverDueHttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.util.AutoScrollRecyclerView;
import com.taiyi.typulse.tyusbsdk.pulse.util.DialogTipUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingView;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.MaiFlowAdapter;
import com.taiyi.typulse.tyusbsdk.pulse.util.OnClickNoDoubleListener;
import com.taiyi.typulse.tyusbsdk.pulse.util.QTimeUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.scenery.ElectricFanLoadingRenderer;
import com.taiyi.typulse.zhimai.ui.activity.BleStateActivity;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class BleMeasureFlowActivity
extends BleStateActivity {
    TextView mTvHand;
    ImageView mIvCancel;
    TextView mTvCun;
    TextView mTvGuan;
    TextView mTvChi;
    AutoScrollRecyclerView mAsrCun;
    AutoScrollRecyclerView mAsrGuan;
    AutoScrollRecyclerView mAsrChi;
    ImageView mIvHand;
    ConstraintLayout mClLoading;
    LoadingView mLv;
    private int hand;
    private MaiFlowAdapter cunAdapter;
    private MaiFlowAdapter guanAdapter;
    private MaiFlowAdapter chiAdapter;
    private int current = 4;
    private int[] changImgIds = new int[]{R.drawable.mai_0, R.drawable.chang_2, R.drawable.chang_4, R.drawable.chang_6, R.drawable.chang_8, R.drawable.chang_10, R.drawable.chang_12, R.drawable.chang_14, R.drawable.chang_16, R.drawable.chang_18, R.drawable.chang_20, R.drawable.chang_25, R.drawable.chang_30, R.drawable.chang_35, R.drawable.chang_40};
    private int[] xiImgIds = new int[]{R.drawable.mai_0, R.drawable.xi_2, R.drawable.xi_4, R.drawable.xi_6, R.drawable.xi_8, R.drawable.xi_10, R.drawable.xi_12, R.drawable.xi_14, R.drawable.xi_16, R.drawable.xi_18, R.drawable.xi_20, R.drawable.xi_25, R.drawable.xi_30, R.drawable.xi_35, R.drawable.xi_40};
    private int[] huaImgIds = new int[]{R.drawable.mai_0, R.drawable.hua_2, R.drawable.hua_4, R.drawable.hua_6, R.drawable.hua_8, R.drawable.hua_10, R.drawable.hua_12, R.drawable.hua_14, R.drawable.hua_16, R.drawable.hua_18, R.drawable.hua_20, R.drawable.hua_25, R.drawable.hua_30, R.drawable.hua_35, R.drawable.hua_40};
    private CountDownTimer mCountTimer;
    private Dialog showDialog;

    @Override
    protected int initLayoutResId() {
        return R.layout.activity_ble_measure_flow;
    }

    @Override
    protected void init() {
        super.init();
        this.getWindow().addFlags(128);
        this.initViews();
        this.mIvCancel.setColorFilter(ContextCompat.getColor((Context)this, (int)R.color.text_black));
        this.hand = BleController.getInstance().getHand();
        this.mTvHand.setText(this.hand == 0 ? R.string.measure_left_hand : R.string.measure_right_hand);
        this.mIvHand.setImageResource(this.hand == 0 ? R.drawable.hand_left : R.drawable.hand_right);
        BleController.getInstance().setMeasureId(11111111);
        BleController.getInstance().setIMeasureListener(new IMeasureListenerHeatMap(){

            @Override
            public void onStartMeasure() {
            }

            @Override
            public void onRealTimeWaveGet(int[] cun, int[] guan, int[] chi, int heart) {
                Log.w((String)"BleMeasureFlowActivity", (String)("cun:" + Arrays.toString(cun)));
                Log.w((String)"BleMeasureFlowActivity", (String)("guan:" + Arrays.toString(guan)));
                Log.w((String)"BleMeasureFlowActivity", (String)("chi:" + Arrays.toString(chi)));
                Log.w((String)"BleMeasureFlowActivity", (String)("heart:" + heart));
                int show = Math.round((float)(heart * 4) / 75.0f);
                if (show < 3) {
                    show = 3;
                }
                if (show > 5) {
                    show = 5;
                }
                Log.w((String)"MeasureFlowActivity", (String)("heart:" + show + " heart:" + (float)(heart * 4) / 75.0f));
                BleMeasureFlowActivity.this.changeFlowImg(BleMeasureFlowActivity.this.mAsrCun, BleMeasureFlowActivity.this.cunAdapter, cun);
                BleMeasureFlowActivity.this.changeFlowImg(BleMeasureFlowActivity.this.mAsrGuan, BleMeasureFlowActivity.this.guanAdapter, guan);
                BleMeasureFlowActivity.this.changeFlowImg(BleMeasureFlowActivity.this.mAsrChi, BleMeasureFlowActivity.this.chiAdapter, chi);
                BleMeasureFlowActivity.this.changeWidth(show);
            }

            @Override
            public void onProgress(int progress) {
            }

            @Override
            public void onCancelMeasure() {
                BleMeasureFlowActivity.this.finish();
            }

            @Override
            public void onPulseResult(Pulsebean pulsebean, PulseFigure pulseFigure, ArrayList<SanBuJiuHou> sanBuJiuHou, PulseCharacter pulseCharacter, TotalPulse totalPulse) {
                BleMeasureFlowActivity.this.uploadResult(pulsebean, pulseFigure, pulseCharacter, totalPulse);
            }

            @Override
            public void onPulseResult(Pulsebean pulsebean, PulseFigure pulseFigure, ArrayList<SanBuJiuHou> sanBuJiuHou, PulseCharacter pulseCharacter, TotalPulse totalPulse, String csvPath) {
                BleMeasureFlowActivity.this.uploadCsv(pulsebean, pulseFigure, pulseCharacter, totalPulse, csvPath);
            }

            @Override
            public void onMeasureFailed(Pulsebean pulsebean) {
                BleMeasureFlowActivity.this.mAsrCun.openAutoScroll(0, false);
                BleMeasureFlowActivity.this.mAsrGuan.openAutoScroll(0, false);
                BleMeasureFlowActivity.this.mAsrChi.openAutoScroll(0, false);
                LogUtil.w("qxj belMeasure Failed", "fail");
                DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.measure_failed), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        BleMeasureFlowActivity.this.setResult(-1);
                        BleMeasureFlowActivity.this.finish();
                    }
                });
            }

            @Override
            public void onTimeOut() {
                BleMeasureFlowActivity.this.mAsrCun.openAutoScroll(0, false);
                BleMeasureFlowActivity.this.mAsrGuan.openAutoScroll(0, false);
                BleMeasureFlowActivity.this.mAsrChi.openAutoScroll(0, false);
                LogUtil.w("qxj belMeasure onTimeOut", "time out");
                DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.measure_failed), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        BleMeasureFlowActivity.this.setResult(-1);
                        BleMeasureFlowActivity.this.finish();
                    }
                });
            }
        });
        this.mAsrCun.post(new Runnable(){

            @Override
            public void run() {
                BleMeasureFlowActivity.this.initFlow();
                BleController.getInstance().startMeasure();
            }
        });
        this.mIvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BleMeasureFlowActivity.this.showDialog();
            }
        });
        ElectricFanLoadingRenderer renderer = new ElectricFanLoadingRenderer.Builder((Context)this).build();
        renderer.setRepeatCount(0);
        this.mLv.setLoadingRenderer(renderer);
        this.mLv.startAnimation();
        this.mClLoading.setOnClickListener((View.OnClickListener)new OnClickNoDoubleListener(){

            @Override
            public void onNoDoubleClick(View view) {
            }
        });
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
    }

    private void initViews() {
        this.mTvHand = (TextView)this.findViewById(R.id.tv_hand);
        this.mIvCancel = (ImageView)this.findViewById(R.id.iv_cancel);
        this.mTvCun = (TextView)this.findViewById(R.id.tv_cun);
        this.mTvGuan = (TextView)this.findViewById(R.id.tv_guan);
        this.mTvChi = (TextView)this.findViewById(R.id.tv_chi);
        this.mAsrCun = (AutoScrollRecyclerView)this.findViewById(R.id.asr_cun);
        this.mAsrGuan = (AutoScrollRecyclerView)this.findViewById(R.id.asr_guan);
        this.mAsrChi = (AutoScrollRecyclerView)this.findViewById(R.id.asr_chi);
        this.mIvHand = (ImageView)this.findViewById(R.id.iv_hand);
        this.mClLoading = (ConstraintLayout)this.findViewById(R.id.cl_loading);
        this.mLv = (LoadingView)this.findViewById(R.id.lv);
    }

    private void uploadCsv(final Pulsebean pulsebean, final PulseFigure pulseFigure, final PulseCharacter pulseCharacter, final TotalPulse totalPulse, String csvPath) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BleMeasureFlowActivity.this.showLoading();
            }
        });
        this.uploadCSV(new TYUsbDeviceActivity.OssInterface(){

            @Override
            public void onStartUpload() {
            }

            @Override
            public void onSuccessUpload(String url) {
                String uid = BleController.getInstance().getUuid();
                PulseParam pulseParam = PulseParam.getParams(TaiyiManager.getInstance().getAppId(), uid, "Android", Build.VERSION.SDK_INT + "", BleController.getInstance().getBleDevice().getName(), uid, uid, pulsebean, pulseFigure, pulseCharacter, totalPulse, url, uid, BleController.getInstance().getGjversion(), BleController.getInstance().getYjversion(), BleController.getInstance().getSjversion(), BleController.getInstance().getHand());
                pulseParam.timezone = QTimeUtil.getTimeZone();
                pulseParam.time = QTimeUtil.toDatetimeStr();
                BleMeasureFlowActivity.this.uploadPulseData(pulseParam);
            }

            @Override
            public void onFailedUpload() {
                BleMeasureFlowActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.unify_8), str -> {
                            BleMeasureFlowActivity.this.setResult(-1);
                            BleMeasureFlowActivity.this.finish();
                        });
                    }
                });
            }
        }, csvPath);
    }

    private void uploadCSV(final TYUsbDeviceActivity.OssInterface ossInterface, String csv) {
        try {
            OssFileUtil.getInstance().upload(this.getApplicationContext(), "mai3/Csv/" + TaiyiManager.getInstance().getUid() + "/" + BleController.getInstance().getFileName(), csv, null, new OSSCompletedCallback<PutObjectRequest, PutObjectResult>(){

                public void onSuccess(final PutObjectRequest request, PutObjectResult result) {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            LogUtils.d("OSS\u4e0a\u4f20\u5b8c\u6210");
                            if (ossInterface != null) {
                                ossInterface.onSuccessUpload(OssFileUtil.endPoint + "/" + request.getBucketName() + "/" + request.getObjectKey());
                            }
                        }
                    });
                }

                public void onFailure(PutObjectRequest request, ClientException clientException, ServiceException serviceException) {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (ossInterface != null) {
                                ossInterface.onFailedUpload();
                            }
                        }
                    });
                }
            });
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private void showLoading() {
        this.mClLoading.setVisibility(0);
        this.mLv.startAnimation();
    }

    private void dismissLoading() {
        this.mLv.stopAnimation();
        this.mClLoading.setVisibility(8);
    }

    private void changeFlowImg(AutoScrollRecyclerView asr, MaiFlowAdapter adapter, int[] data) {
        int lastVisibleItemPosition = ((LinearLayoutManager)asr.getLayoutManager()).findLastVisibleItemPosition();
        if (lastVisibleItemPosition != -1) {
            int[] imgIds;
            int level = data[0];
            if (level > 14) {
                level = 14;
            }
            switch (data[1]) {
                case 1: {
                    imgIds = this.xiImgIds;
                    break;
                }
                case 2: {
                    imgIds = this.huaImgIds;
                    break;
                }
                default: {
                    imgIds = this.changImgIds;
                }
            }
            for (int i = lastVisibleItemPosition + 1; i < adapter.getData().size(); ++i) {
                adapter.getData().set(i, imgIds[level]);
            }
            adapter.notifyDataSetChanged();
        }
    }

    private void changeWidth(int show) {
        if (this.current != show) {
            this.current = show;
            this.cunAdapter.setWidth(this.mAsrCun.getWidth() / show);
            this.guanAdapter.setWidth(this.mAsrGuan.getWidth() / show);
            this.chiAdapter.setWidth(this.mAsrChi.getWidth() / show);
        }
    }

    private void initFlow() {
        int speed = 100;
        LinearLayoutManager layoutCun = new LinearLayoutManager((Context)this, 0, false);
        this.mAsrCun.setLayoutManager((RecyclerView.LayoutManager)layoutCun);
        if (this.cunAdapter == null) {
            this.cunAdapter = new MaiFlowAdapter(this.mAsrCun.getWidth() / 4);
        }
        ArrayList<Integer> cun = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            cun.add(R.drawable.mai_0);
        }
        this.cunAdapter.setNewData(cun);
        this.mAsrCun.setAdapter((RecyclerView.Adapter)this.cunAdapter);
        this.mAsrCun.openAutoScroll(speed, false);
        LinearLayoutManager layoutGuan = new LinearLayoutManager((Context)this, 0, false);
        this.mAsrGuan.setLayoutManager((RecyclerView.LayoutManager)layoutGuan);
        if (this.guanAdapter == null) {
            this.guanAdapter = new MaiFlowAdapter(this.mAsrGuan.getWidth() / 4);
        }
        ArrayList<Integer> guan = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            guan.add(R.drawable.mai_0);
        }
        this.guanAdapter.setNewData(guan);
        this.mAsrGuan.setAdapter((RecyclerView.Adapter)this.guanAdapter);
        this.mAsrGuan.openAutoScroll(speed, false);
        LinearLayoutManager layoutChi = new LinearLayoutManager((Context)this, 0, false);
        this.mAsrChi.setLayoutManager((RecyclerView.LayoutManager)layoutChi);
        if (this.chiAdapter == null) {
            this.chiAdapter = new MaiFlowAdapter(this.mAsrChi.getWidth() / 4);
        }
        ArrayList<Integer> chi = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            chi.add(R.drawable.mai_0);
        }
        this.chiAdapter.setNewData(chi);
        this.mAsrChi.setAdapter((RecyclerView.Adapter)this.chiAdapter);
        this.mAsrChi.openAutoScroll(speed, false);
    }

    private void uploadResult(Pulsebean pulsebean, PulseFigure pulseFigure, PulseCharacter pulseCharacter, TotalPulse totalPulse) {
        String uid = BleController.getInstance().getUuid();
        LogUtil.w(this.TAG, "uid:" + uid);
        PulseParam pulseParam = PulseParam.getParams(TaiyiManager.getInstance().getAppId(), uid, "Android", Build.VERSION.SDK_INT + "", BleController.getInstance().getBleDevice().getName(), uid, uid, pulsebean, pulseFigure, pulseCharacter, totalPulse, null, uid, BleController.getInstance().getGjversion(), BleController.getInstance().getYjversion(), BleController.getInstance().getSjversion(), BleController.getInstance().getHand());
        HttpUtil.getInstance().getRequestQueue((Context)this).saveMai(pulseParam, new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
                LogUtil.w("error", error);
                DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.error_http), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        BleMeasureFlowActivity.this.setResult(-1);
                        BleMeasureFlowActivity.this.finish();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                BleMeasureFlowActivity.this.setResult(-1);
                BleMeasureFlowActivity.this.finish();
            }
        });
    }

    private void uploadPulseData(PulseParam pulseParam) {
        HttpUtil.getInstance().saveHeatMapMai(pulseParam, new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
                LogUtil.w("qxj upload error", error);
                BleMeasureFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        BleMeasureFlowActivity.this.setResult(-1);
                        BleMeasureFlowActivity.this.finish();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                BleMeasureFlowActivity.this.startGetResultStatus();
            }
        });
    }

    private void startGetResultStatus() {
        if (this.mCountTimer == null) {
            this.mCountTimer = new CountDownTimer(29000L, 3000L){

                public void onTick(long millisUntilFinished) {
                    BleMeasureFlowActivity.this.getResultStatus();
                }

                public void onFinish() {
                    LogUtil.d("qxj startGetResultStatus onFinish ", "error");
                    DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            BleMeasureFlowActivity.this.setResult(-1);
                            BleMeasureFlowActivity.this.finish();
                        }
                    });
                }
            };
        }
        this.mCountTimer.start();
    }

    private void getResultStatus() {
        HttpUtil.getInstance().getRequestQueue((Context)this).getResultStatus(BleController.getInstance().getUuid(), new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
                DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.error_http), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        BleMeasureFlowActivity.this.setResult(-1);
                        BleMeasureFlowActivity.this.finish();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                if (response != null && !response.trim().isEmpty()) {
                    try {
                        JSONObject jsonObject = new JSONObject(response);
                        if (jsonObject.has("measure_result") && jsonObject.optInt("measure_result") != 0) {
                            BleMeasureFlowActivity.this.setResult(-1);
                            BleMeasureFlowActivity.this.finish();
                        } else {
                            BleMeasureFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                                @Override
                                public void onSuccess(String str) {
                                    BleMeasureFlowActivity.this.setResult(-1);
                                    BleMeasureFlowActivity.this.finish();
                                }
                            });
                        }
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                    if (BleMeasureFlowActivity.this.mCountTimer != null) {
                        BleMeasureFlowActivity.this.mCountTimer.cancel();
                        BleMeasureFlowActivity.this.mCountTimer = null;
                    }
                }
            }
        });
    }

    private void getResultStatus1() {
        HttpUtil.getInstance().getRequestQueue((Context)this).getResultStatus(BleController.getInstance().getUuid(), new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
                DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.error_http), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        BleMeasureFlowActivity.this.setResult(-1);
                        BleMeasureFlowActivity.this.finish();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                LogUtil.e("qxj getResultStatus showResponse:", response);
                if (response != null && !response.trim().isEmpty()) {
                    try {
                        JSONObject jsonObject = new JSONObject(response);
                        if (jsonObject.has("measure_result") && jsonObject.optInt("measure_result") != 0) {
                            BleMeasureFlowActivity.this.setResult(-1);
                            BleMeasureFlowActivity.this.finish();
                        } else {
                            BleMeasureFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                                @Override
                                public void onSuccess(String str) {
                                    BleMeasureFlowActivity.this.setResult(-1);
                                    BleMeasureFlowActivity.this.finish();
                                }
                            });
                        }
                    }
                    catch (JSONException e) {
                        LogUtil.e("qxj getResultStatus", "JSON parsing error: " + e.getMessage() + ", response: " + response);
                        BleMeasureFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.measure_data_error), new DialogTipUtil.CommonCallback_I(){

                            @Override
                            public void onSuccess(String str) {
                                BleMeasureFlowActivity.this.setResult(-1);
                                BleMeasureFlowActivity.this.finish();
                            }
                        });
                    }
                    if (BleMeasureFlowActivity.this.mCountTimer != null) {
                        BleMeasureFlowActivity.this.mCountTimer.cancel();
                        BleMeasureFlowActivity.this.mCountTimer = null;
                    }
                } else {
                    LogUtil.e("qxj ", "Empty or null response received");
                    BleMeasureFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)BleMeasureFlowActivity.this, BleMeasureFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            BleMeasureFlowActivity.this.setResult(-1);
                            BleMeasureFlowActivity.this.finish();
                        }
                    });
                }
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.getWindow().clearFlags(128);
    }

    private void showDialog() {
        DialogTipUtil.showSelectDialog((Context)this, this.getString(R.string.measure_cancel), this.getString(R.string.measure_cancel_tip), R.string.app_cancel, R.string.app_confirm, new DialogTipUtil.OptionClickCallback_I(){

            @Override
            public void leftClick() {
            }

            @Override
            public void rightClick() {
                BleController.getInstance().cancelMeasure();
            }
        });
    }

    public void onBackPressed() {
        this.showDialog();
    }

    @Override
    @RequiresApi(api=19)
    protected void otherAction() {
    }
}

