/*
 * Decompiled with CFR 0.152.
 */
package com.tzbank.uniplugin_cashier;

import android.app.Activity;
import java.util.Stack;

public class ActivityController {
    private static Stack<Activity> activityStack;
    private static ActivityController instance;

    private ActivityController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityController getInstance() {
        if (instance != null) return instance;
        Class<ActivityController> clazz = ActivityController.class;
        synchronized (ActivityController.class) {
            if (instance != null) return instance;
            instance = new ActivityController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack();
        }
        activityStack.add(activity);
    }

    public Activity currentActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        return activity;
    }

    public void finishActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        this.finishActivity(activity);
    }

    public void finishActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity.finish();
        }
    }

    public void finishActivity(Class<?> cls) {
        for (Activity activity : activityStack) {
            if (!activity.getClass().equals(cls)) continue;
            this.finishActivity(activity);
        }
    }

    public void finishAllActivity() {
        for (int i = 0; i < activityStack.size(); ++i) {
            if (null == activityStack.get(i)) continue;
            ((Activity)activityStack.get(i)).finish();
        }
        activityStack.clear();
    }
}

