/*
 * Decompiled with CFR 0.152.
 */
package com.tzbank.uniplugin_cashier;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.tzbank.uniplugin_cashier.PayRequestConfig;
import com.tzbank.uniplugin_cashier.PaymentCallback;
import com.tzbank.uniplugin_cashier.ShowCashierActivity;
import com.tzbank.uniplugin_cashier.TzPayImpl;
import org.json.JSONException;
import org.json.JSONObject;

public class CashierManager {
    private static volatile CashierManager sCashierManager;
    PayRequestConfig mPayRequestConfig;
    private Context mContext;
    PaymentCallback mPaymentCallback;
    TzPayImpl mTzPay;
    private String tzCardPayForResult;

    private CashierManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CashierManager getInstance() {
        if (sCashierManager != null) return sCashierManager;
        Class<CashierManager> clazz = CashierManager.class;
        synchronized (CashierManager.class) {
            if (sCashierManager != null) return sCashierManager;
            sCashierManager = new CashierManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sCashierManager;
        }
    }

    public void init(PayRequestConfig payRequestConfig) {
        this.mPayRequestConfig = payRequestConfig;
        this.mContext = payRequestConfig.getContext();
        this.mTzPay = payRequestConfig.getTzPay();
        if (this.mTzPay == null) {
            throw new RuntimeException("\u8bf7\u5728\u8c03\u7528\u7684\u65f6\u5019\u9700\u5b9e\u73b0TzPayImpl\u63a5\u53e3\u6765\u5b8c\u6210\u4e00\u4e9b\u529f\u80fd");
        }
    }

    public void launchPayment(String jsonStr, PaymentCallback paymentCallback) {
        if (this.mContext == null) {
            throw new RuntimeException("\u8bf7\u5148\u8c03\u7528\u521d\u59cb\u5316(init())\u65b9\u6cd5");
        }
        this.mPaymentCallback = paymentCallback;
        ShowCashierActivity.jumpShowCashier(this.mContext, jsonStr);
    }

    public String getTzCardPayForResult() {
        return this.tzCardPayForResult;
    }

    public void setTzCardPayForResult(String tzCardPayForResult) {
        this.tzCardPayForResult = tzCardPayForResult;
        try {
            JSONObject jsonObject = new JSONObject(tzCardPayForResult);
            Intent intent = new Intent("callBack");
            Bundle bundle = new Bundle();
            bundle.putString("result", jsonObject.optString("orderStatus"));
            intent.putExtras(bundle);
            LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject getTzCardPayForResult(JSONObject jsonObject) {
        return jsonObject;
    }

    public TzPayImpl getTzPay() {
        return this.mTzPay;
    }
}

