/*
 * Decompiled with CFR 0.152.
 */
package com.tzbank.uniplugin_cashier;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.tzbank.uniplugin_cashier.CashierManager;
import com.tzbank.uniplugin_cashier.PayRequestConfig;
import com.tzbank.uniplugin_cashier.PaymentCallback;
import com.tzbank.uniplugin_cashier.TzPayImpl;
import com.tzbank.uniplugin_cashier.constant.Env;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;
import org.json.JSONObject;

public class PayModule
extends UniModule {
    @UniJSMethod
    public void add(com.alibaba.fastjson.JSONObject json, UniJSCallback callback) {
        final int a = json.getIntValue("a");
        final int b = json.getIntValue("b");
        callback.invoke((Object)new com.alibaba.fastjson.JSONObject(){
            {
                this.put("code", 0);
                this.put("result", a + b);
            }
        });
    }

    @UniJSMethod
    public void pay(com.alibaba.fastjson.JSONObject json, final UniJSCallback callback) {
        if (this.mUniSDKInstance != null && this.mUniSDKInstance.getContext() instanceof Activity) {
            Activity activity = (Activity)this.mUniSDKInstance.getContext();
            int env = json.getIntValue("env");
            String cashierWebUrl = json.getString("cashierWebUrl");
            String wxAppId = json.getString("wxAppId");
            String wxMiniProgramId = json.getString("wxMiniProgramId");
            int wxMiniProgramType = json.getIntValue("wxMiniProgramType");
            String orderJsonString = this.parseAsOrderJsonString(json);
            PayRequestConfig config = new PayRequestConfig.Builder().setContext((Context)activity).setCashierWebUrl(this.getCashierWebUrlApplied(cashierWebUrl, env)).setWXAppId(wxAppId).setWXMiniProgramId(wxMiniProgramId).setWXMiniProgramType(wxMiniProgramType).setProdEnv(env == 0).setTzPay(new TzPayImpl(){

                @Override
                public void goTzCardPay(JSONObject jsonObject) {
                }
            }).builder();
            CashierManager.getInstance().init(config);
            CashierManager.getInstance().launchPayment(orderJsonString, new PaymentCallback(){

                @Override
                public void paymentResult(final String status) {
                    if (callback != null) {
                        callback.invoke((Object)new com.alibaba.fastjson.JSONObject(){
                            {
                                this.put("orderStatus", status);
                            }
                        });
                    }
                }
            });
        }
    }

    private String getCashierWebUrlApplied(String cashierWebUrl, int env) {
        if (!TextUtils.isEmpty((CharSequence)cashierWebUrl)) {
            return cashierWebUrl;
        }
        if (env == 0) {
            return Env.PROD.getCashierWebUrl();
        }
        if (env == 1) {
            return Env.UAT.getCashierWebUrl();
        }
        if (env == 2) {
            return Env.REG.getCashierWebUrl();
        }
        return Env.PROD.getCashierWebUrl();
    }

    private String parseAsOrderJsonString(com.alibaba.fastjson.JSONObject jsonObj) {
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        if (jsonObj != null) {
            String orderFlowNo = jsonObj.getString("orderFlowNo");
            String businessCstNo = jsonObj.getString("businessCstNo");
            String platMerCstNo = jsonObj.getString("platMerCstNo");
            String frontBackUrl = jsonObj.getString("frontBackUrl");
            jsonObject.put("orderFlowNo", (Object)orderFlowNo);
            jsonObject.put("businessCstNo", (Object)businessCstNo);
            jsonObject.put("platMerCstNo", (Object)platMerCstNo);
            jsonObject.put("frontBackUrl", (Object)frontBackUrl);
        }
        return jsonObject.toJSONString();
    }
}

