/*
 * Decompiled with CFR 0.152.
 */
package com.tzbank.uniplugin_cashier;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.MimeTypeMap;
import android.webkit.ValueCallback;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbiz.WXLaunchMiniProgram;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import com.tzbank.uniplugin_cashier.ActivityController;
import com.tzbank.uniplugin_cashier.CashierManager;
import com.tzbank.uniplugin_cashier.PayRequestConfig;
import com.tzbank.uniplugin_cashier.PaymentCallback;
import com.tzbank.uniplugin_cashier.R;
import com.tzbank.uniplugin_cashier.TzPayImpl;
import com.tzbank.uniplugin_cashier.YinlianWebActivity;
import com.tzbank.uniplugin_cashier.constant.Env;
import com.unionpay.UPPayAssistEx;
import org.json.JSONException;
import org.json.JSONObject;

public class ShowCashierActivity
extends AppCompatActivity {
    public static final String TAG = ShowCashierActivity.class.getSimpleName();
    private Button mCloseBtn;
    private WebView mShowWb;
    private String mJsonStr;
    private static final int REQUEST = 1;
    private LocalBroadcastManager broadcastManager;
    private BroadcastReceiver mReceiver;
    private IWXAPI api;

    public static void jumpShowCashier(Context context, String jsonStr) {
        Intent intent = new Intent(context, ShowCashierActivity.class);
        intent.putExtra("jsonStr", jsonStr);
        context.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_show_cashier);
        ActivityController.getInstance().addActivity((Activity)this);
        this.mJsonStr = this.getIntent().getStringExtra("jsonStr");
        this.setupView();
        this.initData();
        this.setBroadCast();
        this.regToWx();
    }

    private void setBroadCast() {
        this.broadcastManager = LocalBroadcastManager.getInstance((Context)this);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("callBack");
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String tzCardPayForResult = intent.getStringExtra("result");
                if (TextUtils.isEmpty((CharSequence)tzCardPayForResult)) {
                    return;
                }
                Log.e((String)"TAG", (String)("\u63a5\u6536\u7684\u56de\u8c03\u7ed3\u679c: " + tzCardPayForResult));
                if (Build.VERSION.SDK_INT < 19) {
                    ShowCashierActivity.this.mShowWb.loadUrl("javascript:appCallback('" + tzCardPayForResult + "')");
                } else {
                    ShowCashierActivity.this.mShowWb.evaluateJavascript("javascript:appCallback('" + tzCardPayForResult + "')", (ValueCallback)new ValueCallback<String>(){

                        public void onReceiveValue(String value) {
                        }
                    });
                }
                Log.e((String)"TAG", (String)"paymentResult: \u8bf7\u6c42\u4e86\u8f6e\u8bad\u7ed3\u679c");
            }
        };
        this.broadcastManager.registerReceiver(this.mReceiver, intentFilter);
    }

    private void regToWx() {
        PayRequestConfig payRequestConfig = CashierManager.getInstance().mPayRequestConfig;
        if (payRequestConfig != null && !TextUtils.isEmpty((CharSequence)payRequestConfig.getWXAppId())) {
            String wxAppId = payRequestConfig.getWXAppId();
            this.api = WXAPIFactory.createWXAPI((Context)this, (String)wxAppId, (boolean)true);
            this.api.registerApp(wxAppId);
        }
    }

    private void setupView() {
        this.initCloseBtn();
        this.initWebView();
    }

    private void initCloseBtn() {
        this.mCloseBtn = (Button)this.findViewById(R.id.closeBtn);
        this.mCloseBtn.setVisibility(8);
        this.mCloseBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShowCashierActivity.this.finish();
            }
        });
    }

    private void initWebView() {
        this.mShowWb = (WebView)this.findViewById(R.id.showWb);
        WebSettings settings = this.mShowWb.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setBlockNetworkImage(false);
        if (Build.VERSION.SDK_INT >= 21) {
            settings.setMixedContentMode(0);
        }
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setDomStorageEnabled(true);
        settings.setUseWideViewPort(true);
        settings.setLoadWithOverviewMode(true);
        settings.setCacheMode(2);
        this.mShowWb.setHapticFeedbackEnabled(false);
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        this.mShowWb.addJavascriptInterface((Object)new CheckoutPlug(), "cashRegister");
        this.mShowWb.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return ShowCashierActivity.this.filter(view, url);
            }

            @RequiresApi(api=21)
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                String url = String.valueOf(request.getUrl());
                return ShowCashierActivity.this.filter(view, url);
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                ShowCashierActivity.this.showCloseBtnIfNeeded(url);
            }
        });
    }

    private void showCloseBtnIfNeeded(String url) {
        Log.d((String)TAG, (String)("showCloseBtnIfNeeded url:" + url));
        if (TextUtils.isEmpty((CharSequence)url) || this.mCloseBtn == null) {
            return;
        }
        if (url.contains("https://d.alipay.com") || url.contains("https://render.alipay.com/p/s/i") || url.contains("showCloseBtn=true")) {
            this.mCloseBtn.setVisibility(0);
        }
    }

    private boolean filter(WebView view, String url) {
        if (url.startsWith("alipays:") || url.startsWith("alipay")) {
            try {
                this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
            }
            catch (Exception e) {
                new AlertDialog.Builder((Context)this).setMessage((CharSequence)"\u672a\u68c0\u6d4b\u5230\u652f\u4ed8\u5b9d\u5ba2\u6237\u7aef\uff0c\u8bf7\u5b89\u88c5\u540e\u91cd\u8bd5\u3002").setPositiveButton((CharSequence)"\u7acb\u5373\u5b89\u88c5", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Uri alipayUrl = Uri.parse((String)"https://d.alipay.com");
                        ShowCashierActivity.this.startActivity(new Intent("android.intent.action.VIEW", alipayUrl));
                    }
                }).setNegativeButton((CharSequence)"\u53d6\u6d88", null).show();
            }
            return true;
        }
        if (!url.startsWith("http") && !url.startsWith("https")) {
            return true;
        }
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl((String)url));
        if ("application/vnd.android.package-archive".equals(mimeType)) {
            this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
            return true;
        }
        view.loadUrl(url);
        return true;
    }

    private void initData() {
        if (!TextUtils.isEmpty((CharSequence)this.mJsonStr)) {
            try {
                JSONObject jsonObject = new JSONObject(this.mJsonStr);
                PayRequestConfig payRequestConfig = CashierManager.getInstance().mPayRequestConfig;
                String cashierWebUrl = Env.PROD.getCashierWebUrl();
                if (payRequestConfig != null && !TextUtils.isEmpty((CharSequence)payRequestConfig.getCashierWebUrl())) {
                    cashierWebUrl = payRequestConfig.getCashierWebUrl();
                }
                this.mShowWb.loadUrl(cashierWebUrl + "?orderNoList=" + jsonObject.optString("orderFlowNo") + "&businessCstNo=" + jsonObject.optString("businessCstNo") + "&platMerCstNo=" + jsonObject.optString("platMerCstNo") + "&sceneNo=01&frontBackUrl=" + jsonObject.optString("payReturnUrl"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void launchaUPPay(String tn) {
        PayRequestConfig payRequestConfig = CashierManager.getInstance().mPayRequestConfig;
        String serverMode = "00";
        if (payRequestConfig != null) {
            serverMode = payRequestConfig.isProdEnv() ? "00" : "01";
        }
        UPPayAssistEx.startPay((Context)this, null, null, (String)tn, (String)serverMode);
    }

    private void handleUPPayResultIfNeeded(int requestCode, int resultCode, Intent data) {
        if (data == null || data.getExtras() == null) {
            return;
        }
        String str = data.getExtras().getString("pay_result");
        if (TextUtils.isEmpty((CharSequence)str)) {
            return;
        }
        if (str.equalsIgnoreCase("success")) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\u652f\u4ed8\u6210\u529f\uff01", (int)0).show();
        } else if (str.equalsIgnoreCase("fail")) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\u652f\u4ed8\u5931\u8d25\uff01", (int)0).show();
        } else if (str.equalsIgnoreCase("cancel")) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\u4f60\u5df2\u53d6\u6d88\u4e86\u672c\u6b21\u8ba2\u5355\u7684\u652f\u4ed8\uff01", (int)0).show();
        }
        String result = str.toLowerCase();
        if (Build.VERSION.SDK_INT < 19) {
            this.mShowWb.loadUrl("javascript:Ylpay_result('" + result + "')");
        } else {
            this.mShowWb.evaluateJavascript("javascript:Ylpay_result('" + result + "')", (ValueCallback)new ValueCallback<String>(){

                public void onReceiveValue(String value) {
                }
            });
        }
    }

    private void openMiniProgramPay(JSONObject jsonObject) {
        boolean supported;
        if (jsonObject == null || this.api == null) {
            return;
        }
        boolean bl = supported = this.api.getWXAppSupportAPI() >= 620823808;
        if (!supported) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"not support", (int)0).show();
        } else {
            PayRequestConfig payRequestConfig = CashierManager.getInstance().mPayRequestConfig;
            if (payRequestConfig != null && TextUtils.isEmpty((CharSequence)payRequestConfig.getWXAppId())) {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"PayRequestConfig.mWXAppId has not been set yet!", (int)0).show();
                return;
            }
            String content = jsonObject.optString("content");
            WXLaunchMiniProgram.Req req = new WXLaunchMiniProgram.Req();
            req.userName = payRequestConfig != null && !TextUtils.isEmpty((CharSequence)payRequestConfig.getWXMiniProgramId()) ? payRequestConfig.getWXMiniProgramId() : "gh_dc8f341e206f";
            req.path = !TextUtils.isEmpty((CharSequence)content) ? "?" + content : null;
            req.miniprogramType = payRequestConfig != null && payRequestConfig.getWXMiniProgramType() != -1 ? payRequestConfig.getWXMiniProgramType() : 0;
            this.api.sendReq((BaseReq)req);
        }
    }

    private void openLargePayment() {
        PayRequestConfig payRequestConfig = CashierManager.getInstance().mPayRequestConfig;
        if (payRequestConfig != null && payRequestConfig.getPageRouter() != null) {
            payRequestConfig.getPageRouter().navigation("LargePayments");
        }
    }

    private void openECNY() {
        PayRequestConfig payRequestConfig = CashierManager.getInstance().mPayRequestConfig;
        if (payRequestConfig != null && payRequestConfig.getPageRouter() != null) {
            payRequestConfig.getPageRouter().navigation("E_CNY");
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == -1) {
            JSONObject jsonObject = new JSONObject();
            if (Build.VERSION.SDK_INT < 19) {
                this.mShowWb.loadUrl("javascript:updateOrderStatus('1')");
            } else {
                this.mShowWb.evaluateJavascript("javascript:updateOrderStatus('1')", (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String value) {
                    }
                });
            }
        }
        this.handleUPPayResultIfNeeded(requestCode, resultCode, data);
    }

    protected void onStop() {
        super.onStop();
        this.finishIfNeeded();
    }

    private void finishIfNeeded() {
        if (this.mShowWb == null || TextUtils.isEmpty((CharSequence)this.mShowWb.getUrl())) {
            return;
        }
        String url = this.mShowWb.getUrl();
        if (url.contains("https://d.alipay.com") || url.contains("https://render.alipay.com/p/s/i") || url.contains("showCloseBtn=true")) {
            PaymentCallback paymentCallback = CashierManager.getInstance().mPaymentCallback;
            if (paymentCallback != null) {
                paymentCallback.paymentResult("60");
            }
            this.finish();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.broadcastManager.unregisterReceiver(this.mReceiver);
    }

    public class CheckoutPlug {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JavascriptInterface
        public void postMessage(String showCheckout) {
            Log.e((String)"TAG", (String)("closeCashRegister: " + showCheckout));
            try {
                JSONObject jsonObject = new JSONObject(showCheckout);
                String orderStatus = jsonObject.optString("orderStatus");
                String method = jsonObject.optString("method");
                if (TextUtils.equals((CharSequence)method, (CharSequence)"closeCashRegister")) {
                    ShowCashierActivity.this.finish();
                    CashierManager.getInstance().mPaymentCallback.paymentResult(orderStatus);
                    return;
                }
                if (TextUtils.equals((CharSequence)method, (CharSequence)"openUnionPay")) {
                    String htmlString = jsonObject.optString("htmlString");
                    Intent intent = new Intent((Context)ShowCashierActivity.this, YinlianWebActivity.class);
                    intent.putExtra("htmlStr", htmlString);
                    ShowCashierActivity.this.startActivityForResult(intent, 1);
                    return;
                }
                if (TextUtils.equals((CharSequence)method, (CharSequence)"openTzPay")) {
                    TzPayImpl tzPay = CashierManager.getInstance().getTzPay();
                    tzPay.goTzCardPay(jsonObject);
                    Log.e((String)"TAG", (String)"\u63a5\u6536\u7684\u56de\u8c03\u7ed3\u679c:openTzPay");
                    return;
                }
                if (TextUtils.equals((CharSequence)method, (CharSequence)"app_cashierPayId")) {
                    String tn = jsonObject.optString("cashierPayId");
                    ShowCashierActivity.this.launchaUPPay(tn);
                    return;
                }
                if (TextUtils.equals((CharSequence)method, (CharSequence)"openMiniProgramPay")) {
                    ShowCashierActivity.this.openMiniProgramPay(jsonObject);
                    return;
                }
                if (!TextUtils.equals((CharSequence)method, (CharSequence)"openLargePayment") && !TextUtils.equals((CharSequence)method, (CharSequence)"openE-CNY")) return;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

